/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.adventure.text.minimessage.tag.standard;

import io.lumine.mythic.bukkit.utils.adventure.text.event.ClickEvent;
import io.lumine.mythic.bukkit.utils.adventure.text.format.Style;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.Context;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.ParsingException;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.internal.serializer.QuotingOverride;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.internal.serializer.SerializableResolver;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.internal.serializer.StyleClaim;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.tag.Tag;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.Nullable;

final class ClickTag {
    private static final String CLICK = "click";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("click", ClickTag::create, StyleClaim.claim("click", Style::clickEvent, (event, emitter) -> emitter.tag(CLICK).argument(ClickEvent.Action.NAMES.key(event.action())).argument(event.value(), QuotingOverride.QUOTED)));

    private ClickTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String actionName = args.popOr(() -> "A click tag requires an action of one of " + ClickEvent.Action.NAMES.keys()).lowerValue();
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(actionName);
        if (action == null) {
            throw ctx.newException("Unknown click event action '" + actionName + "'", args);
        }
        String value = args.popOr("Click event actions require a value").value();
        return Tag.styling(ClickEvent.clickEvent(action, value));
    }
}

