/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.listeners;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.volatilecode.VolatileMaterial;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EggListeners
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void EggEvent(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK && e.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        if (e.getItem().getType() != VolatileMaterial.SPAWN_EGG) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack itemStack = e.getItem();
        CompoundTag compTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(itemStack);
        if (!compTag.containsKey("MYTHIC_EGG")) {
            return;
        }
        e.setCancelled(true);
        String internalName = compTag.getString("MYTHIC_EGG");
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Detected a Mythic Egg usage for {0}", internalName);
        MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(internalName).orElseGet(() -> null);
        if (mm4 == null) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            AbstractLocation location = BukkitAdapter.adapt(e.getClickedBlock().getLocation()).clone().add(0.5, 1.0, 0.5);
            mm4.spawn(location, WorldScaling.getLevelBonus(location));
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ Mythic Mob {0} was spawned from an egg.", mm4.getInternalName());
        } else if (e.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemStack stack = itemStack.clone();
            stack.setAmount(1);
            Item entity = player.getWorld().dropItem(player.getLocation().clone().add(0.0, 1.5, 0.0), stack);
            entity.setThrower(player.getUniqueId());
            entity.setCanMobPickup(false);
            entity.setCanPlayerPickup(false);
            entity.setVelocity(player.getLocation().getDirection().multiply(1));
            Schedulers.sync().runLater(() -> {
                mm4.spawn(BukkitAdapter.adapt(entity.getLocation()), 1.0);
                entity.remove();
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ Mythic Mob {0} was spawned from an egg.", mm4.getInternalName());
            }, 25L);
        }
        if (itemStack.getAmount() > 1) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        } else {
            MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().destroyItem(itemStack);
            player.updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void DispenseEggEvent(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DROPPER) {
            return;
        }
        if (e.getItem().getType() != VolatileMaterial.SPAWN_EGG) {
            return;
        }
        ItemStack itemStack = e.getItem();
        CompoundTag compTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(itemStack);
        if (!compTag.containsKey("MYTHIC_EGG")) {
            return;
        }
        String internalName = compTag.getString("MYTHIC_EGG");
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Detected a Mythic Egg usage for {0}", internalName);
        MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(internalName).orElseGet(() -> null);
        if (mm4 == null) {
            return;
        }
        Block block = e.getBlock();
        BlockFace blockFace = ((Directional)block.getBlockData()).getFacing();
        AbstractLocation location = BukkitAdapter.adapt(block.getLocation());
        if (blockFace == BlockFace.DOWN) {
            location.add(0.5, -1.95, 0.5);
        } else if (blockFace == BlockFace.UP) {
            location.add(0.5, 1.0, 0.5);
        } else if (blockFace == BlockFace.EAST) {
            location.add(1.5, 0.0, 0.5);
        } else if (blockFace == BlockFace.WEST) {
            location.add(-0.5, 0.0, 0.5);
        } else if (blockFace == BlockFace.NORTH) {
            location.add(0.5, 0.0, -0.5);
        } else if (blockFace == BlockFace.SOUTH) {
            location.add(0.5, 0.0, 1.5);
        }
        mm4.spawn(location, 1.0);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Mythic Mob " + mm4.getInternalName() + " was spawned from a dispensed egg.", new Object[0]);
        e.setCancelled(true);
        Dispenser dispenser = (Dispenser)block.getState();
        Inventory dispenserInventory = dispenser.getInventory();
        for (ItemStack stack : dispenserInventory.getContents()) {
            if (stack == null || !stack.isSimilar(itemStack)) continue;
            if (stack.getAmount() > 1) {
                stack.setAmount(stack.getAmount() - 1);
                break;
            }
            MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().destroyItem(stack);
            break;
        }
    }
}

