/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Zombie;

public class BukkitZombie
extends BukkitEntityType {
    private static final int height = 2;
    private double reinforcementChance = -1.0;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Zombie e = (Zombie)this.spawnEntity(location, EntityType.ZOMBIE, reason, prespawnFunc);
        e.setBaby(false);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof Zombie;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

