/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class BukkitWolf
extends BukkitEntityType
implements TameableEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private boolean angry = false;
    private DyeColor color = null;
    private boolean tameable = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, Sets.immutableEnumSet((Enum)Material.BONE, (Enum[])new Material[0]));
        this.angry = mc.getBoolean("Options.Angry", false);
        String strColor = mc.getString("Options.Color");
        if (strColor != null) {
            try {
                this.color = DyeColor.valueOf((String)strColor);
            }
            catch (Exception exception) {
                MythicLogger.errorGenericConfig("Invalid collar color specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.WOLF, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Wolf e = (Wolf)entity;
        e = (Wolf)this.ageableProperty.applyProperties((Entity)e);
        e.setAngry(this.angry);
        if (this.color != null) {
            e.setCollarColor(this.color);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Wolf;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public AbstractPlayer getOwner(ActiveMob am) {
        Wolf w;
        Entity e = BukkitAdapter.adapt(am.getEntity());
        if (e instanceof Wolf && (w = (Wolf)e).getOwner() instanceof Player) {
            return BukkitAdapter.adapt((Player)w.getOwner());
        }
        return null;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

