/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;
import org.bukkit.entity.TraderLlama;

public class BukkitTraderLlama
extends BukkitEntityType
implements TameableEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private Llama.Color color;
    private boolean carryingChest;
    private boolean tamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, Sets.immutableEnumSet((Enum)Material.WHEAT, (Enum[])new Material[]{Material.HAY_BLOCK}));
        this.carryingChest = mc.getBoolean("Options.CarryingChest", false);
        this.tamed = mc.getBoolean("Options.Tamed", false);
        String strColor = mc.getString("Options.Color", "WHITE");
        try {
            this.color = Llama.Color.valueOf((String)strColor.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid Llama color specified");
            this.color = Llama.Color.WHITE;
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        TraderLlama e = (TraderLlama)this.spawnEntity(location, EntityType.TRADER_LLAMA, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        TraderLlama e = (TraderLlama)entity;
        this.ageableProperty.applyProperties(entity);
        e.setColor(this.color);
        if (this.carryingChest) {
            e.setCarryingChest(true);
        }
        if (this.tamed) {
            e.setTamed(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof TraderLlama;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

