/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Phantom;

public class BukkitPhantom
extends BukkitEntityType {
    private static final int height = 2;
    private int size = -1;

    @Override
    public void instantiate(MythicConfig mc) {
        this.size = mc.getInteger("Options.Size", -1);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.PHANTOM, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Phantom e = (Phantom)entity;
        if (this.size > 0) {
            e.setSize(this.size);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Phantom;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

