/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;

public class BukkitPanda
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private String mainGene;
    private String hiddenGene;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.mainGene = mc.getString("Options.MainGene", null);
        this.hiddenGene = mc.getString("Options.HiddenGene", null);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.PANDA, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Panda e = (Panda)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.mainGene != null) {
            e.setMainGene(Panda.Gene.valueOf((String)this.mainGene.toUpperCase()));
        }
        if (this.hiddenGene != null) {
            e.setHiddenGene(Panda.Gene.valueOf((String)this.hiddenGene.toUpperCase()));
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Panda;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

