/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;

public class BukkitFallingBlock
extends BukkitEntityType {
    private static final int height = 1;
    private Material type = Material.STONE;
    private boolean dropsItem = true;
    private boolean hurtsEntities = true;

    @Override
    public void instantiate(MythicConfig mc) {
        String mat = mc.getString("Options.Block", "STONE");
        try {
            this.type = Material.getMaterial((String)mat.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("Invalid falling block material specified");
        }
        this.dropsItem = mc.getBoolean("Options.DropsItem", true);
        this.hurtsEntities = mc.getBoolean("Options.HurtsEntities", true);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return location.getWorld().spawnFallingBlock(location, this.type.createBlockData());
    }

    @Override
    public Entity applyOptions(Entity entity) {
        FallingBlock fallingBlock = (FallingBlock)entity;
        fallingBlock.setDropItem(this.dropsItem);
        fallingBlock.setHurtEntities(this.hurtsEntities);
        return fallingBlock;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof FallingBlock;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

