/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitAxolotl
extends BukkitEntityType
implements TameableEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private boolean tameable;
    private String type;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameableProperty = new TameableProperty(mc, Sets.immutableEnumSet((Enum)Material.WATER_BUCKET, (Enum[])new Material[]{Material.TROPICAL_FISH_BUCKET}));
        this.tameable = mc.getBoolean("Options.Tameable", false);
        this.type = mc.getString("Options.Type", null);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.AXOLOTL, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Axolotl e = (Axolotl)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.type != null) {
            e.setVariant(Axolotl.Variant.valueOf((String)this.type.toUpperCase()));
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Axolotl;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }
}

