/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.util.math.OrientedBoundingBox;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.util.BoundingBox;

public class ModelEngineSupport
extends ReloadableModule<MythicBukkit> {
    public ModelEngineSupport(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
    }

    @Override
    public void unload() {
    }

    public ModeledEntity getModeledEntity(AbstractEntity entity) {
        return ModelEngineAPI.api.getModelManager().getModeledEntity(entity.getUniqueId());
    }

    public AbstractEntity getParent(AbstractEntity entity) {
        ModeledEntity model = this.getModeledEntity(entity);
        if (model != null) {
            UUID id = model.getEntity().getUniqueId();
            Optional<ActiveMob> mob = ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMob(id);
            if (mob.isPresent()) {
                return mob.get().getEntity();
            }
        }
        return entity;
    }

    public boolean isModeledEntity(AbstractEntity entity) {
        return null != this.getModeledEntity(entity);
    }

    public boolean overlapsOOBB(BoundingBox boundingBox, AbstractEntity entity) {
        OrientedBoundingBox obb = ModelEngineAPI.api.getNMSUtils().getOrientedBoundingBox(entity.getBukkitEntity());
        return obb != null && obb.overlaps(boundingBox);
    }

    public BlueprintBone getBlueprintBone(String modelId, String partId) throws Exception {
        ModelBlueprint blueprint = ModelEngineAPI.getModelBlueprint((String)modelId);
        if (blueprint == null) {
            throw new Exception(String.format("Model %s is not registered.", modelId));
        }
        BlueprintBone bone = blueprint.getBone(partId);
        if (bone == null) {
            throw new Exception(String.format("Part %s is not a part of %s.", partId, modelId));
        }
        return bone;
    }
}

