/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.holograms.HologramProvider;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysSupport
implements HologramProvider,
Listener {
    private final MythicBukkit core;

    public HolographicDisplaysSupport(MythicBukkit mm4) {
        this.core = mm4;
    }

    @Override
    public void cleanup() {
        try {
            HologramsAPI.getHolograms((Plugin)this.core).forEach(hologram -> hologram.delete());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public IHologram createHologram(String name, AbstractLocation location, String text) {
        return new HolographicDisplays(name, location, text);
    }

    public class HolographicDisplays
    implements IHologram {
        private Hologram hologram;

        public HolographicDisplays(String name, AbstractLocation location, String text) {
            Schedulers.sync().run(() -> {
                this.hologram = HologramsAPI.createHologram((Plugin)HolographicDisplaysSupport.this.core, (Location)BukkitAdapter.adapt(location));
                this.hologram.setAllowPlaceholders(false);
                this.hologram.appendTextLine(text);
            });
        }

        @Override
        public void close() {
            Schedulers.sync().run(() -> {
                this.hologram.clearLines();
                this.hologram.delete();
            });
        }

        @Override
        public void teleport(AbstractLocation location) {
            Schedulers.sync().run(() -> {
                try {
                    if (!this.hologram.isDeleted()) {
                        this.hologram.teleport(BukkitAdapter.adapt(location).add(0.0, 0.38, 0.0));
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.terminate();
                }
            });
        }

        @Override
        public void setText(String text) {
            Schedulers.sync().run(() -> {
                if (this.hologram.isDeleted()) {
                    return;
                }
                if (this.hologram.size() > 0) {
                    ((TextLine)this.hologram.getLine(0)).setText(text);
                } else {
                    this.hologram.appendTextLine(text);
                }
            });
        }

        @Override
        public void setText(String[] text, String linePrefix) {
            Schedulers.sync().run(() -> {
                this.hologram.clearLines();
                for (String string : text) {
                    this.hologram.appendTextLine(linePrefix + string);
                }
            });
        }
    }
}

