/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CrucibleSupport;
import io.lumine.mythic.bukkit.compatibility.GriefPreventionSupport;
import io.lumine.mythic.bukkit.compatibility.HeroesSupport;
import io.lumine.mythic.bukkit.compatibility.HologramsSupport;
import io.lumine.mythic.bukkit.compatibility.HolographicDisplaysSupport;
import io.lumine.mythic.bukkit.compatibility.LibsDisguisesSupport;
import io.lumine.mythic.bukkit.compatibility.MMOItemsSupport;
import io.lumine.mythic.bukkit.compatibility.MPetCompat;
import io.lumine.mythic.bukkit.compatibility.ModelEngineSupport;
import io.lumine.mythic.bukkit.compatibility.MythicDropsSupport;
import io.lumine.mythic.bukkit.compatibility.MythicEnchantsSupport;
import io.lumine.mythic.bukkit.compatibility.MythicKeysSupport;
import io.lumine.mythic.bukkit.compatibility.MythicLibSupport;
import io.lumine.mythic.bukkit.compatibility.NoCheatPlusSupport;
import io.lumine.mythic.bukkit.compatibility.OpenTerrainGeneratorSupport;
import io.lumine.mythic.bukkit.compatibility.PhatLootsSupport;
import io.lumine.mythic.bukkit.compatibility.PlaceholderAPISupport;
import io.lumine.mythic.bukkit.compatibility.ProtocolLibSupport;
import io.lumine.mythic.bukkit.compatibility.SkillAPISupport;
import io.lumine.mythic.bukkit.compatibility.VaultSupport;
import io.lumine.mythic.bukkit.compatibility.WorldGuardSupport;
import io.lumine.mythic.bukkit.compatibility.mcMMOSupport;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Optional;
import org.bukkit.Bukkit;

public class CompatibilityManager
implements Terminable {
    private Optional<CrucibleSupport> artifacts = Optional.empty();
    private Optional<MythicEnchantsSupport> mythicEnchants = Optional.empty();
    private Optional<GriefPreventionSupport> griefPrevention = Optional.empty();
    private Optional<HologramsSupport> holograms = Optional.empty();
    private Optional<HolographicDisplaysSupport> holographicDisplays = Optional.empty();
    private Optional<ModelEngineSupport> ModelEngine = Optional.empty();
    private Optional<MPetCompat> miniaturePets = Optional.empty();
    private Optional<MMOItemsSupport> MMOItems = Optional.empty();
    private Optional<MythicLibSupport> MythicLib = Optional.empty();
    private Optional<NoCheatPlusSupport> noCheatPlus = Optional.empty();
    private Optional<OpenTerrainGeneratorSupport> openTerrainGenerator = Optional.empty();
    private Optional<PlaceholderAPISupport> placeholderAPI = Optional.empty();
    private Optional<ProtocolLibSupport> protocolLib = Optional.empty();
    private Optional<VaultSupport> vault = Optional.empty();
    private Optional<WorldGuardSupport> worldGuard = Optional.empty();
    private Optional<MythicKeysSupport> mythicKeys = Optional.empty();
    public static HeroesSupport Heroes = null;
    public static LibsDisguisesSupport LibsDisguises = null;
    public static mcMMOSupport mcMMO = null;
    public static MythicDropsSupport MythicDrops = null;
    public static PhatLootsSupport PhatLoots = null;
    public static SkillAPISupport SkillAPI = null;

    public CompatibilityManager(MythicBukkit core) {
        this.registerCompatibility("MythicCrucible", () -> {
            this.artifacts = Optional.of(new CrucibleSupport());
        });
        this.registerCompatibility("MythicEnchants", () -> {
            this.mythicEnchants = Optional.of(new MythicEnchantsSupport());
        });
        this.registerCompatibility("ModelEngine", () -> {
            this.ModelEngine = Optional.of(new ModelEngineSupport(core));
        });
        this.registerCompatibility("MythicKeysPlugin", () -> {
            this.mythicKeys = Optional.of(new MythicKeysSupport(core));
        });
        this.registerCompatibility("GriefPrevention", () -> {
            this.griefPrevention = Optional.of(new GriefPreventionSupport(core));
        });
        this.registerCompatibility("Heroes", () -> {
            Heroes = new HeroesSupport();
        });
        this.registerCompatibility("Holograms", () -> {
            this.holograms = Optional.of(new HologramsSupport(core));
        });
        this.registerCompatibility("HolographicDisplays", () -> {
            this.holographicDisplays = Optional.of(new HolographicDisplaysSupport(core));
        });
        this.registerCompatibility("LibsDisguises", () -> {
            LibsDisguises = new LibsDisguisesSupport();
        });
        this.registerCompatibility("mcMMO", () -> {
            mcMMO = new mcMMOSupport();
        });
        this.registerCompatibility("MiniaturePets", () -> {
            this.miniaturePets = Optional.of(new MPetCompat());
        });
        this.registerCompatibility("MMOItems", () -> {
            this.MMOItems = Optional.of(new MMOItemsSupport(core));
        });
        this.registerCompatibility("MythicLib", () -> {
            this.MythicLib = Optional.of(new MythicLibSupport(core));
        });
        this.registerCompatibility("MythicDrops", () -> {
            MythicDrops = new MythicDropsSupport();
        });
        this.registerCompatibility("NoCheatPlus", () -> {
            this.noCheatPlus = Optional.of(new NoCheatPlusSupport());
        });
        this.registerCompatibility("OpenTerrainGenerator", () -> {
            this.openTerrainGenerator = Optional.of(new OpenTerrainGeneratorSupport());
        });
        this.registerCompatibility("PhatLoots", () -> {
            PhatLoots = new PhatLootsSupport();
        });
        this.registerCompatibility("PlaceholderAPI", () -> {
            this.placeholderAPI = Optional.of(new PlaceholderAPISupport(core));
        });
        this.registerCompatibility("ProtocolLib", () -> {
            this.protocolLib = Optional.of(new ProtocolLibSupport(core));
        });
        this.registerCompatibility("SkillAPI", () -> {
            SkillAPI = new SkillAPISupport();
        });
        this.registerCompatibility("Vault", () -> {
            this.vault = Optional.of(new VaultSupport());
        });
        this.registerCompatibility("WorldGuard", () -> {
            this.worldGuard = Optional.of(new WorldGuardSupport());
        });
    }

    @Override
    public void close() {
    }

    private void registerCompatibility(String name, Runnable run) {
        try {
            if (Bukkit.getPluginManager().getPlugin(name) != null) {
                run.run();
                MythicLogger.log("MythicMobs " + name + " Support has been enabled!");
            }
        }
        catch (NoClassDefFoundError er) {
            MythicLogger.errorCompatibility(name, "Plugin not found/incompatible version");
            if (ConfigExecutor.debugLevel > 0) {
                er.printStackTrace();
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to enable support for " + name + ". Is it up to date?");
            ex.printStackTrace();
        }
    }

    public Optional<CrucibleSupport> getArtifacts() {
        return this.artifacts;
    }

    public Optional<MythicEnchantsSupport> getMythicEnchants() {
        return this.mythicEnchants;
    }

    public Optional<GriefPreventionSupport> getGriefPrevention() {
        return this.griefPrevention;
    }

    public Optional<HologramsSupport> getHolograms() {
        return this.holograms;
    }

    public Optional<HolographicDisplaysSupport> getHolographicDisplays() {
        return this.holographicDisplays;
    }

    public Optional<ModelEngineSupport> getModelEngine() {
        return this.ModelEngine;
    }

    public Optional<MPetCompat> getMiniaturePets() {
        return this.miniaturePets;
    }

    public Optional<MMOItemsSupport> getMMOItems() {
        return this.MMOItems;
    }

    public Optional<MythicLibSupport> getMythicLib() {
        return this.MythicLib;
    }

    public Optional<NoCheatPlusSupport> getNoCheatPlus() {
        return this.noCheatPlus;
    }

    public Optional<OpenTerrainGeneratorSupport> getOpenTerrainGenerator() {
        return this.openTerrainGenerator;
    }

    public Optional<PlaceholderAPISupport> getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public Optional<ProtocolLibSupport> getProtocolLib() {
        return this.protocolLib;
    }

    public Optional<VaultSupport> getVault() {
        return this.vault;
    }

    public Optional<WorldGuardSupport> getWorldGuard() {
        return this.worldGuard;
    }

    public Optional<MythicKeysSupport> getMythicKeys() {
        return this.mythicKeys;
    }
}

