/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class GetItemInfoCommand
extends Command<MythicBukkit> {
    public GetItemInfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        block13: {
            Player p = (Player)sender;
            ItemStack item = p.getInventory().getItemInMainHand();
            if (item == null || item.getType().equals((Object)Material.AIR)) {
                CommandHelper.sendError(sender, "You must be holding a valid item!");
                return true;
            }
            sender.sendMessage(ColorString.get("&6&lInformation About Held Item&f:"));
            sender.sendMessage(ColorString.get("&6Material&f: &7" + item.getType().toString()));
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                if (meta.hasDisplayName()) {
                    sender.sendMessage(ColorString.get("&6Item Display&f: &7" + meta.getDisplayName()));
                }
                try {
                    if (meta instanceof Damageable) {
                        sender.sendMessage(ColorString.get("&6Durability&f: &7" + ((Damageable)meta).getDamage() + " / " + item.getType().getMaxDurability()));
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            try {
                CompoundTag compoundTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item);
                sender.sendMessage(ColorString.get("&6NBT&f: &7"));
                if (compoundTag.getValue().size() == 0) {
                    sender.sendMessage(ColorString.get("&7-- &fNone"));
                    break block13;
                }
                for (Map.Entry entry : compoundTag.getValue().entrySet()) {
                    String key = (String)entry.getKey();
                    Tag value = (Tag)entry.getValue();
                    if (value instanceof CompoundTag) {
                        sender.sendMessage(ColorString.get("&7-- &f" + key + "&e: "));
                        for (Map.Entry entry2 : ((CompoundTag)value).getValue().entrySet()) {
                            String key2 = (String)entry2.getKey();
                            Tag value2 = (Tag)entry2.getValue();
                            sender.sendMessage(ColorString.get("&7---- &f" + key2 + " &7 == &e" + value2.toString()));
                        }
                        continue;
                    }
                    sender.sendMessage(ColorString.get("&7-- &f" + key + " &7 == &e" + value.toString()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities.getiteminfo";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getiteminfo";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"gii"};
    }
}

