/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateCommand
extends Command<MythicBukkit> {
    public CreateCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Command Format: " + ChatColor.AQUA + "/mm spawners create [name] [mob_name]");
            return true;
        }
        name = args[0];
        if (name == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a name for the spawner.");
            return true;
        }
        maybeSpawner = MythicBukkit.inst().getSpawnerManager().getSpawnerByHashcode(name.hashCode());
        if (maybeSpawner.isPresent()) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner name must resolve to a unique hashcode.");
            return true;
        }
        level = new RandomInt(1);
        if (args[1].contains(":")) {
            split = args[1].split(":");
            mobName = split[0];
            try {
                level = new RandomInt(split[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid mob level supplied: must be an integer or range (1, 2to5, etc).");
                return true;
            }
        } else {
            mobName = args[1];
        }
        if (mobName == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a Mythic Mob for the spawner to spawn.");
            return true;
        }
        if (MythicBukkit.inst().getMobManager().getMythicMob(args[1]) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Mob. That one was not found!");
            return true;
        }
        location = null;
        if (args.length > 2) {
            try {
                part = args[2].split(",");
                w = Bukkit.getWorld((String)part[0]);
                x = Float.parseFloat(part[1]);
                y = Float.parseFloat(part[2]);
                z = Float.parseFloat(part[3]);
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Parsing location using: " + w.toString() + "," + x + "," + y + "," + z, new Object[0]);
                if (w == null) ** GOTO lbl49
                location = new Location(w, (double)x, (double)y, (double)z);
            }
            catch (Exception e) {
                CommandHelper.sendError(sender, "Invalid location specified for spawner: location must be in format world,x,y,z");
                return true;
            }
        } else if (sender instanceof Player) {
            location = ((Player)sender).getTargetBlock((Set)null, 10).getLocation();
        } else {
            CommandHelper.sendError(sender, "Invalid location specified for spawner: location must be in format world,x,y,z");
            return true;
        }
lbl49:
        // 3 sources

        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to place the spawner!");
            return true;
        }
        ms = MythicBukkit.inst().getSpawnerManager().createSpawner(name, location, mobName);
        if (ms != null) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "New spawner was created successfully!");
            ms.setMobLevel(level);
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner creation failed: spawner name is probably already taken!");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.create";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"cr", "c"};
    }
}

