/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class InfoCommand
extends Command<MythicBukkit> {
    public InfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            CommandHelper.sendError(sender, "Usage /mm m[obs] i[nfo] <internal-name>");
            return true;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(args[0]) != null) {
            MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(args[0]).orElseGet(() -> null);
            sender.sendMessage(ColorString.get("&e&lInformation for &a" + mm4.getInternalName() + "&7:"));
            sender.sendMessage(ChatColor.GOLD + "Mob ID: " + ChatColor.GRAY + mm4.hashCode());
            sender.sendMessage(ChatColor.GOLD + "Display Name: " + ChatColor.GRAY + mm4.getDisplayName());
            sender.sendMessage(ChatColor.GOLD + "EntityType: " + ChatColor.GRAY + mm4.getEntityType());
            sender.sendMessage(ChatColor.GOLD + "Damage: " + ChatColor.GRAY + mm4.getDamage().toString() + " (+" + mm4.getPerLevelDamage() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Health: " + ChatColor.GRAY + mm4.getHealth() + " (+" + mm4.getPerLevelHealth() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Armor: " + ChatColor.GRAY + mm4.getArmor().toString() + " (+" + mm4.getPerLevelArmor() + " per level)");
            sender.sendMessage(ChatColor.GOLD + "Power per Level: +" + ChatColor.GRAY + mm4.getPerLevelPower());
            sender.sendMessage(ChatColor.GOLD + "Located in File: " + ChatColor.GRAY + mm4.getFile());
        } else {
            CommandHelper.sendError(sender, "No Mythic Mob loaded with the name " + args[0]);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.info";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"i"};
    }
}

