/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.items.MythicItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class GetCommand
extends Command<MythicBukkit> {
    public GetCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /mm item get <name>");
            return true;
        }
        String item = args[0];
        int amount = 1;
        if (args.length > 1) {
            amount = Integer.valueOf(args[1]);
        }
        AbstractPlayer target = BukkitAdapter.adapt(p);
        DropMetadataImpl meta = new DropMetadataImpl(new GenericCaster(target), target);
        Optional<DropTable> maybeDrops = MythicBukkit.inst().getDropManager().getDropTable(item);
        if (maybeDrops.isPresent()) {
            DropTable dt = maybeDrops.get();
            if (dt.hasDrops()) {
                for (int i = 0; i < amount; ++i) {
                    LootBag loot = dt.generate(meta);
                    loot.give(target);
                }
            }
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().isPresent()) {
                ((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().get().reparseWeapon(target);
            }
            BukkitAdapter.adapt(target).updateInventory();
            CommandHelper.sendSuccess(sender, "DropTable &b" + item + " &awas put in your inventory!");
            return true;
        }
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            MythicItem mi = maybeItem.get();
            for (int i = 0; i < amount; ++i) {
                try {
                    p.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt(mi.generateItemStack(meta, 1))});
                    continue;
                }
                catch (Exception ex) {
                    CommandHelper.sendError(sender, "Could not get item: item is improperly configured and returned null.");
                    if (ConfigExecutor.debugLevel > 0) {
                        ex.printStackTrace();
                    }
                    return true;
                }
            }
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().isPresent()) {
                ((MythicBukkit)this.getPlugin()).getCompatibility().getArtifacts().get().reparseWeapon(BukkitAdapter.adapt(p));
            }
            p.updateInventory();
            CommandHelper.sendSuccess(sender, "Item &b" + item + " &awas put in your inventory!");
        } else {
            CommandHelper.sendError(sender, "No Mythic Item loaded with the name " + item + ".");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> itemNames = new ArrayList<String>(((MythicBukkit)this.getPlugin()).getItemManager().getItemNames());
            for (DropTable s2 : ((MythicBukkit)this.getPlugin()).getDropManager().getDropTables()) {
                itemNames.add(s2.getInternalName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], itemNames, new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.get";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "get";
    }
}

