/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.eggs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.mobs.EggManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class GetCommand
extends Command<MythicBukkit> {
    public GetCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /mm egg get <mob_name> [amount]");
            return true;
        }
        MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(args[0]).orElseGet(() -> null);
        int amount = 1;
        if (args.length > 1) {
            amount = Integer.valueOf(args[1]);
        }
        if (mm4 == null) {
            CommandHelper.sendError(sender, "No Mythic Mob loaded with the name " + args[0] + ".");
            return true;
        }
        if (EggManager.giveMythicEgg(mm4, p, amount)) {
            CommandHelper.sendSuccess(sender, "Got " + ChatColor.AQUA + amount + ChatColor.GREEN + " Mythic Eggs" + ChatColor.GREEN + "!");
        } else {
            CommandHelper.sendError(sender, "An error occured, could not get mob egg.");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.eggs.get";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "get";
    }
}

