/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands;

import io.lumine.mythic.bukkit.utils.adventure.text.Component;
import io.lumine.mythic.bukkit.utils.text.Text;
import org.bukkit.command.CommandSender;

public class CommandHelper {
    public static final Component COMMAND_HEADER = Text.parse("<yellow><strikethrough>------------<gold>=====</strikethrough> <bold><gradient:#20DAE9:#2815EC>Mythic</gradient></bold> <strikethrough><gold>=====<yellow>------------</strikethrough>");
    public static final Component COMMAND_FOOTER = Text.parse("<yellow><strikethrough>-------------</strikethrough> <gradient:#20DAE9:#2815EC>www.mythiccraft.io</gradient> <yellow><strikethrough>-------------</strikethrough>");
    public static final Component COMMAND_PREFIX = Text.parse("<bold><gray>[<gradient:#20DAE9:#2815EC>Mythic</gradient><gray>]</bold> ");

    public static void sendHeader(CommandSender sender) {
        Text.sendMessage(sender, COMMAND_HEADER);
    }

    public static void sendFooter(CommandSender sender) {
        Text.sendMessage(sender, COMMAND_FOOTER);
    }

    public static void sendSuccess(CommandSender sender, String message) {
        Text.sendMessage(sender, COMMAND_PREFIX.append(Text.parse("<green>" + message)));
    }

    public static void sendError(CommandSender sender, String message) {
        Text.sendMessage(sender, COMMAND_PREFIX.append(Text.parse("<red>" + message)));
    }

    public static void sendCommandMessage(CommandSender player, String[] ... args) {
        CommandHelper.sendHeader(player);
        player.sendMessage(" ");
        String[][] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] s2;
            for (String ss : s2 = stringArray[i]) {
                Text.sendMessage(player, ss);
            }
        }
        player.sendMessage(" ");
        CommandHelper.sendFooter(player);
    }

    public static void sendCommandMessage(CommandSender player, Component[] ... args) {
        CommandHelper.sendHeader(player);
        player.sendMessage(" ");
        Component[][] componentArray = args;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] s2;
            for (Component ss : s2 = componentArray[i]) {
                Text.sendMessage(player, ss);
            }
        }
        player.sendMessage(" ");
        CommandHelper.sendFooter(player);
    }

    private CommandHelper() {
    }
}

