/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.adventure.PaperHelper;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitItemStack
extends ItemFactory
implements AbstractItemStack,
Cloneable {
    private ItemType itemType = ItemType.NORMAL;
    private Object mythicItem = null;
    private int amount = 1;

    public BukkitItemStack(String type) {
        if (type.toLowerCase().startsWith("mmoitems.") && MythicBukkit.inst().getCompatibility().getMMOItems().isPresent()) {
            this.itemType = ItemType.MMOITEMS;
            this.mythicItem = MythicBukkit.inst().getCompatibility().getMMOItems().get().getCustomItem(type.substring(9));
            return;
        }
        if (type.toLowerCase().startsWith("droptable.")) {
            this.itemType = ItemType.MYTHIC_DROPTABLE;
            return;
        }
        Optional<MythicItem> maybeItem = MythicBukkit.inst().getItemManager().getItem(type);
        if (maybeItem.isPresent()) {
            this.itemType = ItemType.MYTHIC;
            this.mythicItem = maybeItem.get();
        } else {
            Material material = Material.matchMaterial((String)type.toUpperCase());
            if (material == null) {
                throw new IllegalArgumentException("BukkitItemStack Material cannot be null (could not find material " + type + ")");
            }
            this.type(material);
        }
    }

    public BukkitItemStack(ItemStack item) {
        super(item);
    }

    public BukkitItemStack(Material material) {
        super(new ItemStack(material));
    }

    @Override
    public BukkitItemStack name(String name) {
        return (BukkitItemStack)(ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16) ? this.transformMeta(meta -> meta.displayName(PaperHelper.parse(name))) : this.transformMeta(meta -> meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name))));
    }

    @Override
    public BukkitItemStack lore(Iterable<String> lines) {
        return (BukkitItemStack)(ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16) ? this.transformMeta(meta -> {
            List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
            for (String line : lines) {
                lore.add(PaperHelper.parse(line));
            }
            meta.lore(lore);
        }) : this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        }));
    }

    @Override
    public BukkitItemStack amount(int d) {
        if (this.itemType == ItemType.NORMAL) {
            super.amount(d);
        }
        this.amount = d;
        return this;
    }

    @Override
    public BukkitItemStack data(int d) {
        super.durability(d);
        return this;
    }

    public BukkitItemStack colorData(DyeColor dc) {
        this.data(dc.getWoolData());
        return this;
    }

    public CompoundTag getNBT() {
        return MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.build());
    }

    @Override
    public ItemStack build() {
        if (this.itemType == ItemType.MMOITEMS) {
            return (ItemStack)this.mythicItem;
        }
        if (this.itemType == ItemType.MYTHIC) {
            MythicMobItemGenerateEvent event = new MythicMobItemGenerateEvent((MythicItem)this.mythicItem, BukkitAdapter.adapt(((MythicItem)this.mythicItem).generateItemStack(1)));
            Events.callSync(event);
            ItemStack item = event.getItemStack();
            if (ServerVersion.isPaper()) {
                item = item.ensureServerConversions();
            }
            return item;
        }
        return super.build();
    }

    public BukkitItemStack clone() {
        return new BukkitItemStack(this.build());
    }

    public boolean isSimilar(ItemStack item) {
        CompoundTag tagComp;
        if (this.itemType == ItemType.MMOITEMS) {
            CompoundTag tagBase = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData((ItemStack)this.mythicItem);
            CompoundTag tagComp2 = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item);
            if (!tagBase.getString("MMOITEMS_ITEM_TYPE").equals(tagComp2.getString("MMOITEMS_ITEM_TYPE"))) {
                return false;
            }
            return tagBase.getString("MMOITEMS_ITEM_ID").equals(tagComp2.getString("MMOITEMS_ITEM_ID"));
        }
        if (this.itemType == ItemType.MYTHIC && (tagComp = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item)).containsKey("MYTHIC_TYPE")) {
            String mythicType = ((MythicItem)this.mythicItem).getInternalName();
            return tagComp.getString("MYTHIC_TYPE").equals(mythicType);
        }
        ItemStack compitem = this.build();
        if (compitem.getType() != item.getType()) {
            return false;
        }
        if (compitem.hasItemMeta()) {
            if (!item.hasItemMeta()) {
                return false;
            }
            ItemMeta thisMeta = compitem.getItemMeta();
            ItemMeta thatMeta = item.getItemMeta();
            if (thisMeta.hasCustomModelData()) {
                if (!thatMeta.hasCustomModelData()) {
                    return false;
                }
                if (thisMeta.getCustomModelData() != thatMeta.getCustomModelData()) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Collection<BukkitItemStack> getMatches(String regex) {
        HashSet<BukkitItemStack> bukkitItemStacks = new HashSet<BukkitItemStack>();
        if (regex.toLowerCase().startsWith("mmoitems.") && MythicBukkit.inst().getCompatibility().getMMOItems().isPresent()) {
            bukkitItemStacks.add(new BukkitItemStack(regex));
        } else {
            for (String itemNames : MythicBukkit.inst().getItemManager().getItemNames()) {
                if (!itemNames.matches(Patterns.toRegex(regex))) continue;
                bukkitItemStacks.add(new BukkitItemStack(itemNames));
            }
            for (Material mats : Material.values()) {
                if (!mats.toString().matches(Patterns.toRegex(regex.toUpperCase()))) continue;
                bukkitItemStacks.add(new BukkitItemStack(mats));
            }
        }
        return bukkitItemStacks;
    }

    public int getAmount() {
        return this.amount;
    }

    private static enum ItemType {
        NORMAL,
        MYTHIC,
        MYTHIC_DROPTABLE,
        MMOITEMS;

    }
}

