/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitPlayer;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class BukkitEntity
implements AbstractEntity {
    private final Entity entityRef;

    public BukkitEntity(Entity e) {
        this.entityRef = e;
    }

    @Override
    public void setCustomName(String name) {
        MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().setCustomName(this, name);
    }

    @Override
    public Entity getBukkitEntity() {
        return this.entityRef;
    }

    private LivingEntity getEntityAsLiving() {
        return (LivingEntity)this.getBukkitEntity();
    }

    private Creature getEntityAsCreature() {
        return (Creature)this.getBukkitEntity();
    }

    public Player getEntityAsPlayer() {
        return (Player)this.getBukkitEntity();
    }

    @Override
    public PersistentDataContainer getDataContainer() {
        return this.getBukkitEntity().getPersistentDataContainer();
    }

    @Override
    public AbstractLocation getLocation() {
        return BukkitAdapter.adapt(this.getBukkitEntity().getLocation());
    }

    @Override
    public AbstractWorld getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public boolean isLiving() {
        return this.getBukkitEntity() instanceof LivingEntity;
    }

    @Override
    public boolean isCreature() {
        return this.getBukkitEntity() instanceof Creature;
    }

    @Override
    public boolean isMonster() {
        return this.getBukkitEntity() instanceof Monster;
    }

    @Override
    public boolean isDamageable() {
        return this.getBukkitEntity() instanceof Damageable;
    }

    @Override
    public boolean isPlayer() {
        return this.getBukkitEntity() instanceof Player;
    }

    @Override
    public UUID getUniqueId() {
        return this.getBukkitEntity().getUniqueId();
    }

    @Override
    public boolean hasLineOfSight(AbstractEntity e) {
        return ((LivingEntity)this.getBukkitEntity()).hasLineOfSight(e.getBukkitEntity());
    }

    @Override
    public boolean hasLineOfSight(AbstractLocation location) {
        return !((LivingEntity)this.getBukkitEntity()).hasLineOfSight(BukkitAdapter.adapt(location));
    }

    @Override
    public void teleport(AbstractLocation l) {
        if (this.getBukkitEntity().isValid() && !this.getBukkitEntity().isDead()) {
            this.getBukkitEntity().teleport(BukkitAdapter.adapt(l));
        }
    }

    @Override
    public double getHealth() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getHealth();
        }
        return 0.0;
    }

    @Override
    public boolean isDead() {
        return this.getBukkitEntity().isDead();
    }

    @Override
    public boolean isValid() {
        return this.getBukkitEntity().isValid();
    }

    @Override
    public boolean remove() {
        Entity entity = this.entityRef;
        if (entity != null && !this.isPlayer()) {
            if (Bukkit.isPrimaryThread()) {
                entity.remove();
                return entity.isDead();
            }
            Schedulers.sync().run(() -> entity.remove());
            return true;
        }
        return true;
    }

    @Override
    public double getMaxHealth() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getMaxHealth();
        }
        return 0.0;
    }

    @Override
    public void setFireTicks(int ticks) {
        this.getBukkitEntity().setFireTicks(ticks);
    }

    @Override
    public String getCustomName() {
        return this.getEntityAsLiving().getCustomName();
    }

    @Override
    public void addPotionEffect(PotionEffect effect) {
        this.getEntityAsLiving().addPotionEffect(effect);
    }

    @Override
    public void setPassenger(Entity entity) {
        this.getBukkitEntity().setPassenger(entity);
    }

    @Override
    public boolean hasGravity() {
        return this.getBukkitEntity().hasGravity();
    }

    @Override
    public void setGravity(boolean bool) {
        this.getBukkitEntity().setGravity(bool);
    }

    @Override
    public boolean hasAI() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().hasAI();
        }
        return false;
    }

    @Override
    public void setAI(boolean bool) {
        if (this.isLiving()) {
            this.getEntityAsLiving().setAI(bool);
        }
    }

    @Override
    public AbstractLocation getEyeLocation() {
        if (this.isLiving()) {
            return BukkitAdapter.adapt(this.getEntityAsLiving().getEyeLocation());
        }
        return BukkitAdapter.adapt(this.getBukkitEntity().getLocation());
    }

    @Override
    public double getEyeHeight() {
        if (this.isLiving()) {
            return this.getEntityAsLiving().getEyeHeight();
        }
        return 0.0;
    }

    @Override
    public AbstractEntity getTarget() {
        if (this.isCreature()) {
            return BukkitAdapter.adapt((Entity)this.getEntityAsCreature().getTarget());
        }
        if (this.getBukkitEntity().getLastDamageCause() != null) {
            return BukkitAdapter.adapt(this.getBukkitEntity().getLastDamageCause().getEntity());
        }
        return null;
    }

    @Override
    public AbstractEntity getPassenger() {
        Entity e = this.getBukkitEntity().getPassenger();
        if (e != null) {
            return BukkitAdapter.adapt(e);
        }
        return null;
    }

    @Override
    public AbstractEntity getVehicle() {
        Entity e = this.getBukkitEntity().getVehicle();
        if (e != null) {
            return BukkitAdapter.adapt(e);
        }
        return null;
    }

    @Override
    public void eject() {
        this.getBukkitEntity().eject();
    }

    @Override
    public void setHealth(double d) {
        Entity e = this.getBukkitEntity();
        if (e instanceof LivingEntity) {
            if (d < 0.0) {
                d = 0.0;
            }
            ((LivingEntity)e).setHealth(d);
        }
    }

    @Override
    public String getName() {
        if (this.isPlayer()) {
            return this.getEntityAsPlayer().getName();
        }
        if (this.getBukkitEntity().getCustomName() != null) {
            return this.getBukkitEntity().getCustomName();
        }
        if (this.getBukkitEntity().getName() != null) {
            return this.getBukkitEntity().getName();
        }
        return this.getBukkitEntity().getType().getName();
    }

    @Override
    public void setMaxHealth(double health) {
        this.getEntityAsLiving().setMaxHealth(health);
    }

    @Override
    public void damage(float damage) {
        this.getEntityAsLiving().damage((double)damage);
    }

    @Override
    public void setPassenger(AbstractEntity entity) {
        this.getBukkitEntity().setPassenger(BukkitAdapter.adapt(entity));
    }

    @Override
    public AbstractPlayer asPlayer() {
        if (this.getBukkitEntity() instanceof Player) {
            return new BukkitPlayer(this.getEntityAsPlayer());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof BukkitEntity) {
            return this.getUniqueId().equals(((BukkitEntity)o).getUniqueId());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getBukkitEntity().getUniqueId().hashCode();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        if (this.isLiving()) {
            ((LivingEntity)this.getBukkitEntity()).setNoDamageTicks(ticks);
        }
    }

    @Override
    public boolean isCitizensNPC() {
        return this.getBukkitEntity().hasMetadata("NPC");
    }

    @Override
    public boolean isAnimal() {
        return this.getBukkitEntity() instanceof Animals;
    }

    @Override
    public boolean isWaterMob() {
        return this.getBukkitEntity() instanceof WaterMob;
    }

    @Override
    public boolean isFlyingMob() {
        return this.getBukkitEntity() instanceof Flying;
    }

    @Override
    public boolean isGliding() {
        return ((LivingEntity)this.getBukkitEntity()).isGliding();
    }

    @Override
    public boolean hasPotionEffect(String type) {
        return this.hasPotionEffect(type, null, null);
    }

    @Override
    public boolean hasPotionEffect(String type, RangedDouble level, RangedDouble duration) {
        if (this.isLiving()) {
            PotionEffectType potiontype;
            LivingEntity e = (LivingEntity)this.getBukkitEntity();
            if (!e.hasPotionEffect(potiontype = PotionEffectType.getByName((String)type))) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed has check", new Object[0]);
                return false;
            }
            PotionEffect effect = e.getPotionEffect(potiontype);
            if (duration != null && !duration.equals(effect.getDuration())) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed duration check", new Object[0]);
                return false;
            }
            if (level != null && !level.equals(effect.getAmplifier())) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "HasPotionEffect failed level check", new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPotionEffect() {
        if (this.isLiving()) {
            LivingEntity e = (LivingEntity)this.getBukkitEntity();
            return e.getActivePotionEffects().size() > 0;
        }
        return false;
    }

    @Override
    public boolean hasScoreboardTag(String tag) {
        return this.getBukkitEntity().getScoreboardTags().contains(tag);
    }

    @Override
    public void addScoreboardTag(String tag) {
        this.getBukkitEntity().addScoreboardTag(tag);
    }

    @Override
    public void removeScoreboardTag(String tag) {
        this.getBukkitEntity().removeScoreboardTag(tag);
    }

    @Override
    public void equipItemHead(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setHelmet(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemChest(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setChestplate(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemLegs(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setLeggings(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemFeet(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setBoots(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemMainHand(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setItemInMainHand(BukkitAdapter.adapt(item));
    }

    @Override
    public void equipItemOffHand(AbstractItemStack item) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        EntityEquipment ee = le.getEquipment();
        assert (ee != null);
        ee.setItemInOffHand(BukkitAdapter.adapt(item));
    }

    @Override
    public void setDamage(double damage) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        if (le.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) != null) {
            le.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(damage);
        }
        if (CompatibilityManager.Heroes != null) {
            CompatibilityManager.Heroes.setMobDamage(le, damage);
        }
    }

    @Override
    public void setArmor(double armor) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        le.getAttribute(Attribute.GENERIC_ARMOR).setBaseValue(armor);
    }

    public double getDamage() {
        if (!this.isLiving()) {
            return 0.0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        if (le.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) != null) {
            return le.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getBaseValue();
        }
        return 0.0;
    }

    @Override
    public void setMovementSpeed(double speed) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        le.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(speed);
    }

    @Override
    public void setAttackSpeed(double speed) {
        if (!this.isLiving()) {
            return;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        le.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(speed);
    }

    @Override
    public int getLuck() {
        if (!this.isLiving()) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        double luck = 0.0;
        if (le.getAttribute(Attribute.GENERIC_LUCK) != null) {
            luck = le.getAttribute(Attribute.GENERIC_LUCK).getValue();
        }
        if (le.getEquipment() != null) {
            luck += (double)le.getEquipment().getItemInMainHand().getEnchantmentLevel(Enchantment.LUCK);
        }
        for (PotionEffect pe : le.getActivePotionEffects()) {
            if (pe.getType() == PotionEffectType.LUCK) {
                luck += (double)pe.getAmplifier();
                continue;
            }
            if (pe.getType() != PotionEffectType.UNLUCK) continue;
            luck -= (double)pe.getAmplifier();
        }
        return (int)luck;
    }

    @Override
    public int getEnchantmentLevel(String enchantmentName) {
        Enchantment enchant;
        if (!this.isLiving()) {
            return 0;
        }
        try {
            enchant = Enchantment.getByName((String)enchantmentName);
        }
        catch (Exception ex) {
            return 0;
        }
        if (enchant == null) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        int level = 0;
        if (le.getEquipment() != null) {
            level += le.getEquipment().getItemInMainHand().getEnchantmentLevel(enchant);
            level += le.getEquipment().getItemInOffHand().getEnchantmentLevel(enchant);
            for (ItemStack item : le.getEquipment().getArmorContents()) {
                level += item.getEnchantmentLevel(enchant);
            }
        }
        return level;
    }

    @Override
    public int getEnchantmentLevelHeld(String enchantmentName) {
        Enchantment enchant;
        if (!this.isLiving()) {
            return 0;
        }
        try {
            enchant = Enchantment.getByName((String)enchantmentName);
        }
        catch (Exception ex) {
            return 0;
        }
        if (enchant == null) {
            return 0;
        }
        LivingEntity le = (LivingEntity)this.getBukkitEntity();
        return le.getEquipment().getItemInMainHand().getEnchantmentLevel(enchant);
    }

    @Override
    public void setMetadata(String key, Object value) {
        Entity e = this.getBukkitEntity();
        e.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)MythicBukkit.inst(), value));
    }

    @Override
    public boolean hasMetadata(String key) {
        Entity e = this.getBukkitEntity();
        return e.hasMetadata(key);
    }

    @Override
    public void removeMetadata(String key) {
        Entity e = this.getBukkitEntity();
        e.removeMetadata(key, (Plugin)MythicBukkit.inst());
    }

    @Override
    public synchronized boolean isLoaded() {
        Entity e = this.getBukkitEntity();
        return e.getLocation().getChunk().isLoaded();
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        Entity e = this.getBukkitEntity();
        List values = e.getMetadata(key);
        for (MetadataValue mv : values) {
            if (!mv.getOwningPlugin().equals(MythicBukkit.inst())) continue;
            return Optional.of(mv.value());
        }
        return Optional.empty();
    }

    @Override
    public AbstractVector getVelocity() {
        Entity e = this.getBukkitEntity();
        if (e == null) {
            return new AbstractVector(0, 0, 0);
        }
        return BukkitAdapter.adapt(e.getVelocity());
    }

    @Override
    public void setVelocity(AbstractVector velocity) {
        Entity e = this.getBukkitEntity();
        Vector v = BukkitAdapter.adapt(velocity);
        e.setVelocity(v);
    }

    @Override
    public boolean isOnGround() {
        return this.getBukkitEntity().isOnGround();
    }

    @Override
    public void setFreezingTicks(int i) {
        this.getBukkitEntity().setFreezeTicks(i);
    }

    @Override
    public boolean isFreezing() {
        return this.getBukkitEntity().getFreezeTicks() > 0;
    }

    @Override
    public int getFreezingTicks() {
        return this.getBukkitEntity().getFreezeTicks();
    }

    @Override
    public int getMaxFreezingTicks() {
        return this.getBukkitEntity().getMaxFreezeTicks();
    }

    @Override
    public void setSavesToDisk(boolean b) {
        this.getBukkitEntity().setPersistent(b);
    }
}

