/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.skills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public record SkillTrigger(String name, List<String> aliases) {
    private static final Map<String, SkillTrigger> TRIGGERS = new HashMap<String, SkillTrigger>();

    public static SkillTrigger trigger(String name) {
        String thatName = name.toUpperCase();
        if (TRIGGERS != null) {
            if (TRIGGERS.containsKey(thatName)) {
                return TRIGGERS.get(thatName);
            }
            for (SkillTrigger skillTrigger : SkillTrigger.values()) {
                if (!skillTrigger.aliases().contains(thatName)) continue;
                return skillTrigger;
            }
        }
        return new SkillTrigger(name.toUpperCase(), new ArrayList<String>());
    }

    public static SkillTrigger get(String name) {
        for (SkillTrigger trigger : SkillTrigger.values()) {
            if (trigger.name().equalsIgnoreCase(name)) {
                return trigger;
            }
            if (!trigger.aliases().contains(name.toUpperCase())) continue;
            return trigger;
        }
        return TRIGGERS.get("DEFAULT");
    }

    public static void register(SkillTrigger trigger) {
        Validate.notNull((Object)trigger, (String)"trigger cannot be null");
        String name = trigger.name().toUpperCase();
        if (!TRIGGERS.containsKey(name)) {
            TRIGGERS.put(name, trigger);
        }
    }

    public static Collection<SkillTrigger> values() {
        return TRIGGERS.values();
    }

    public void register() {
        SkillTrigger.register(this);
    }
}

