/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_17_R1;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileWorldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class VolatileWorldHandler_v1_17_R1
implements VolatileWorldHandler {
    public Thread resetServerThread;

    public VolatileWorldHandler_v1_17_R1(VolatileCodeHandler handler) {
    }

    @Override
    public void registerWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void unregisterWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkAt(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
        if (chunk == null) {
            return 0;
        }
        return chunk.bukkitChunk.getEntities().length;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.getType(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        EntityFallingBlock block = new EntityFallingBlock((World)nmsWorld, (double)target.getBlockX() + 0.5, (double)(target.getBlockY() + 1), (double)target.getBlockZ() + 0.5, blockState);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)block, block.getEntityType(), BlockBell.getCombinedId((IBlockData)blockState), blockPosition);
        PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.getId(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (hideSourceBlock) {
                p.sendBlockChange(location, Material.AIR, (byte)0);
            }
            ((CraftPlayer)p).getHandle().b.sendPacket((Packet)packet);
            ((CraftPlayer)p).getHandle().b.sendPacket((Packet)packetV);
            Schedulers.async().runLater(() -> {
                PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.getId()});
                ((CraftPlayer)p).getHandle().b.sendPacket((Packet)packet2);
                if (hideSourceBlock) {
                    p.sendBlockChange(location, location.getBlock().getType(), (byte)0);
                }
            }, duration);
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = Numbers.floor((location.getX() - radius) / 16.0);
        int bigX = Numbers.floor((location.getX() + radius) / 16.0);
        int smallZ = Numbers.floor((location.getZ() - radius) / 16.0);
        int bigZ = Numbers.floor((location.getZ() + radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
                if (null == chunk) continue;
                for (Entity e : chunk.bukkitChunk.getEntities()) {
                    AbstractEntity entity = BukkitAdapter.adapt(e);
                    if (predicate != null && !predicate.test(entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull(start, "Start location is null!", new Object[0]);
        start.checkFinite();
        Validate.notNull(direction, "Direction is null!", new Object[0]);
        direction.checkFinite();
        Validate.isTrue(direction.lengthSquared() > 0.0, "Direction's magnitude is 0!", new Object[0]);
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection entities = start.getWorld().getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        double distance;
        if (direction.lengthSquared() < 1.0E-5 || maxDistance <= 1.0E-5) {
            return null;
        }
        RayTraceResult blockRayTrace = null;
        RayTraceResult entityRayTrace = start.getWorld().rayTraceEntities(start, direction, maxDistance, raySize, entityFilter);
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            distance = start.distance(entityRayTrace.getHitEntity().getLocation());
            if (distance == 0.0) {
                distance = maxDistance;
            }
        } else {
            distance = maxDistance;
        }
        BlockIterator bIterator = new BlockIterator(start.getWorld(), start.toVector(), direction, 0.0, (int)Math.ceil(distance));
        Block block = null;
        while (bIterator.hasNext()) {
            RayTraceResult res;
            block = bIterator.next();
            if (block.isEmpty() || blockFilter.test(block.getType()) || (res = block.rayTrace(start, direction, distance, FluidCollisionMode.ALWAYS)) == null) continue;
            blockRayTrace = res;
            break;
        }
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            if (blockRayTrace != null) {
                return blockRayTrace;
            }
            return entityRayTrace;
        }
        if (blockRayTrace != null) {
            return blockRayTrace;
        }
        return new RayTraceResult(block.getLocation().toVector());
    }

    @Override
    public void changeWorldServerThread(org.bukkit.World world) {
    }

    @Override
    public void restoreWorldServerThread(org.bukkit.World world) {
    }

    @Override
    public Entity spawnInvisibleArmorStand(Location location) {
        WorldServer w = ((CraftWorld)location.getWorld()).getHandle();
        EntityArmorStand nmsEntity = new EntityArmorStand((World)w, location.getX(), location.getY(), location.getZ());
        nmsEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        nmsEntity.setInvisible(true);
        w.addEntity((net.minecraft.world.entity.Entity)nmsEntity);
        return nmsEntity.getBukkitEntity();
    }
}

