/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_17_R1;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.xikage.mythicmobs.volatilecode.v1_17_R1.CompoundTag_v1_17_R1;
import java.util.HashSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class VolatileEntityHandler_v1_17_R1
implements VolatileEntityHandler {
    public VolatileEntityHandler_v1_17_R1(VolatileCodeHandler handler) {
    }

    @Override
    public float getEntityAbsorptionHearts(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return 0.0f;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        return el.getAbsorptionHearts();
    }

    @Override
    public void setEntityAbsorptionHearts(AbstractEntity entity, float value) {
        if (!entity.isLiving()) {
            return;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        el.setAbsorptionHearts(value);
    }

    @Override
    public void setLocation(AbstractEntity entity, AbstractLocation location) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        net.minecraft.world.entity.Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.setLocation(x, y, z, yaw, pitch);
        if (entity.isPlayer()) {
            this.playerConnectionTeleport(entity, x, y, z, yaw, pitch, noRotation, noGravity);
        }
        if (e.t instanceof WorldServer) {
            ((WorldServer)e.t).addEntity(e);
        }
    }

    @Override
    public void setPlayerRotation(AbstractPlayer entity, float yaw, float pitch) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.a);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.b);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.c);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
        me.b.sendPacket((Packet)new PacketPlayOutPosition(0.0, 0.0, 0.0, yaw, pitch, set, 0, false));
    }

    private void playerConnectionTeleport(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        boolean dismountVehicle = false;
        if (noRotation) {
            pitch = 0.0f;
            yaw = 0.0f;
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.e);
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.d);
        }
        if (noGravity) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.b);
            y = 0.0;
        }
        me.b.sendPacket((Packet)new PacketPlayOutPosition(x, y, z, yaw, pitch, set, 0, dismountVehicle));
    }

    @Override
    public boolean isEntityInMotion(AbstractEntity entity, boolean exact) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.getPositionVector();
            if (exact) {
                if (e.u != position.getX() || e.v != position.getY() || e.w != position.getZ()) {
                    return true;
                }
            } else {
                int x = Numbers.floor(e.u);
                int y = Numbers.floor(e.v);
                int z = Numbers.floor(e.w);
                int pX = Numbers.floor(position.getX());
                int pY = Numbers.floor(position.getY());
                int pZ = Numbers.floor(position.getZ());
                if (x != pX || y != pY || z != pZ) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setHitBox(AbstractEntity target, double a0, double a1, double a2) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        me.a(AxisAlignedBB.a((Vec3D)me.getBoundingBox().f(), (double)a0, (double)a1, (double)a2));
    }

    @Override
    public void setItemPosition(AbstractEntity target, AbstractLocation ol) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity instanceof Item) {
            Item item = (Item)entity;
            EntityItem ei = (EntityItem)((CraftItem)item).getHandle();
            ei.g(ol.getX(), ol.getY(), ol.getZ());
        }
    }

    @Override
    public void sendEntityTeleportPacket(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        PacketPlayOutEntityTeleport tp = new PacketPlayOutEntityTeleport(me);
        entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), 32.0, 32.0, 32.0).forEach(e -> {
            if (e instanceof Player) {
                ((CraftPlayer)e).getHandle().b.sendPacket((Packet)tp);
            }
        });
    }

    @Override
    public void setEntityRotation(AbstractEntity target, float pitch, float yaw) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        me.setYRot(yaw);
        me.setXRot(pitch);
    }

    @Override
    public void setArmorStandNoGravity(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        if (entity.getType() == EntityType.ARMOR_STAND) {
            EntityArmorStand as = (EntityArmorStand)((CraftEntity)entity).getHandle();
            as.setNoGravity(true);
        }
    }

    @Override
    public void sendGameStateChange(AbstractPlayer target, int state, int skybox) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(state), (float)skybox);
        ((CraftPlayer)player).getHandle().b.sendPacket((Packet)packet);
    }

    @Override
    public void forcePlayCredits(AbstractPlayer target, float f) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.sendPacket((Packet)new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(4), f));
    }

    @Override
    public void forceCloseWindow(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.b.sendPacket((Packet)new PacketPlayOutCloseWindow(0));
    }

    @Override
    public void setPlayerWorldBorder(AbstractPlayer target, AbstractLocation center, int radius) {
        WorldBorder border;
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (radius == -1) {
            border = ep.getWorldServer().getWorldBorder();
        } else {
            border = new WorldBorder();
            border.world = ep.getWorldServer().getWorldBorder().world;
            border.setCenter(center.getX(), center.getZ());
            border.setSize((double)radius);
            border.setWarningDistance(1);
        }
        ep.b.sendPacket((Packet)new ClientboundSetBorderCenterPacket(border));
        ep.b.sendPacket((Packet)new ClientboundSetBorderWarningDistancePacket(border));
        ep.b.sendPacket((Packet)new ClientboundSetBorderSizePacket(border));
    }

    @Override
    public void sendPlayerFakeInventoryItem(AbstractPlayer target, ItemStack stack, int slot) {
        if (slot < 9) {
            slot += 36;
        }
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy((ItemStack)stack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(0, 0, slot, item);
        entityPlayer.b.sendPacket((Packet)packet);
    }

    public void hideEntityModel(AbstractEntity target) {
        Entity entity = BukkitAdapter.adapt(target);
        net.minecraft.world.entity.Entity me = ((CraftEntity)entity).getHandle();
        DataWatcher w = me.getDataWatcher();
        w.set(new DataWatcherObject(0, DataWatcherRegistry.a), (Object)32);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(me.getId(), w, true);
    }

    @Override
    public void playTotemEffect(AbstractPlayer target, int model) {
        this.sendPlayerFakeInventoryItem(target, ItemFactory.of(Material.TOTEM_OF_UNDYING).model(model).build(), 45);
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)me, 35);
        me.b.sendPacket((Packet)packet);
        player.stopSound(Sound.ITEM_TOTEM_USE, SoundCategory.MASTER);
        Schedulers.async().runLater(() -> this.sendPlayerFakeInventoryItem(target, player.getInventory().getItemInOffHand(), 45), 1L);
    }

    @Override
    public void setEntitySpawnReason(AbstractEntity target, CreatureSpawnEvent.SpawnReason reason) {
        Entity entity = BukkitAdapter.adapt(target);
        org.bukkit.World world = BukkitAdapter.adapt(target.getWorld());
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        worldHandle.addEntity(entityHandle, reason);
    }

    @Override
    public void spawnFakeLightning(AbstractLocation target, double radius) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.World world = location.getWorld();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        EntityLightning entitylightning = (EntityLightning)EntityTypes.U.a((World)worldHandle);
        entitylightning.b(Vec3D.a((BaseBlockPosition)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        entitylightning.setEffect(true);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entitylightning);
        double distanceSquared = radius * radius;
        Schedulers.async().run(() -> {
            for (Player player : location.getWorld().getPlayers()) {
                if (!(location.distanceSquared(player.getLocation()) <= distanceSquared)) continue;
                ((CraftPlayer)player).getHandle().b.sendPacket((Packet)spawnItem);
                player.playSound(location, "entity.lightning_bolt.impact", 1.0f, 1.0f);
                player.playSound(location, "entity.lightning_bolt.thunder", 10000.0f, 63.0f);
            }
        });
    }

    @Override
    public AbstractEntity addNBTData(AbstractEntity entity, String key, Tag value) {
        CompoundTag compound = this.getNBTData(entity).createBuilder().put(key, value).build();
        this.setNBTData(entity, compound);
        return entity;
    }

    @Override
    public CompoundTag getNBTData(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        NBTTagCompound compound = new NBTTagCompound();
        return CompoundTag_v1_17_R1.fromNMSTag(compound);
    }

    @Override
    public AbstractEntity setNBTData(AbstractEntity entity, CompoundTag compoundTag) {
        Entity bukkitEntity = entity.getBukkitEntity();
        return entity;
    }

    @Override
    public void sendActionBarMessageToPlayer(AbstractPlayer target, String message) {
        Player player = BukkitAdapter.adapt(target);
    }
}

