/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_17_R1;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileBlockHandler;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;

public class VolatileBlockHandler_v1_17_R1
implements VolatileBlockHandler {
    public VolatileBlockHandler_v1_17_R1(VolatileCodeHandler handler) {
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        Block block = iblockdata.getBlock();
        world.update(blockposition, block);
    }

    @Override
    public void togglePowerable(AbstractLocation location) {
        this.togglePowerable(location, 0L);
    }

    @Override
    public void togglePowerable(AbstractLocation location, long duration) {
        Location l = BukkitAdapter.adapt(location);
        org.bukkit.block.Block block = l.getWorld().getBlockAt(l);
        BlockData bd = block.getBlockData();
        if (bd instanceof Powerable) {
            Powerable pbd = (Powerable)bd;
            pbd.setPowered(true);
            block.setBlockData((BlockData)pbd);
            this.applyPhysics(block);
            Schedulers.sync().runLater(() -> {
                pbd.setPowered(false);
                block.setBlockData((BlockData)pbd);
                this.applyPhysics(block);
            }, duration);
        }
    }

    @Override
    public void togglePiston(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.block.Block block = location.getBlock();
        if (block.getType() != Material.PISTON) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Location was not piston", new Object[0]);
            return;
        }
        BlockData bd = block.getBlockData();
        Piston redstone = (Piston)bd;
        boolean extended = redstone.isExtended();
        BlockFace bf = ((Directional)bd).getFacing();
        if (extended) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
        redstone.setExtended(true);
        block.setBlockData((BlockData)redstone);
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        boolean bold = BlockPiston.a((IBlockData)iblockdata, (World)world, (BlockPosition)blockposition, (EnumDirection)EnumDirection.c, (boolean)true, (EnumDirection)EnumDirection.d);
        if (!bold) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
    }
}

