/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_16_R3.ai.targeters;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.ai.WrappedPathfindingGoal;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;
import io.lumine.xikage.mythicmobs.volatilecode.v1_16_R3.ai.PathfinderHolder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityCreature;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.PathfinderGoal;
import net.minecraft.server.v1_16_R3.PathfinderGoalNearestAttackableTarget;

@MythicAIGoal(name="nearestSpecificFaction", aliases={"specificFaction"}, description="Target a nearby entity that is in a specific faction")
public class SpecificFactionGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    private Set<String> faction = Sets.newHashSet();

    public SpecificFactionGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        String[] split;
        String factions = mlc.getString(new String[]{"faction", "f"}, this.dataVar1, new String[0]);
        if (factions == null) {
            return;
        }
        for (String s2 : split = factions.split(",")) {
            this.faction.add(s2.toUpperCase());
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        EntityInsentient e = PathfinderHolder.getNMSEntity(this.entity);
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityLiving.class, 0, true, false, targetEntity -> {
            try {
                ActiveMob mob = SpecificFactionGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((org.bukkit.entity.Entity)((Entity)targetEntity).getBukkitEntity());
                if (mob == null) {
                    return false;
                }
                if (target.isPlayer()) {
                    for (String faction : this.faction) {
                        if (!SpecificFactionGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), faction)) continue;
                        return true;
                    }
                } else {
                    Optional<ActiveMob> maybeTargetAM = SpecificFactionGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                    if (!maybeTargetAM.isPresent()) {
                        return false;
                    }
                    ActiveMob targetAM = maybeTargetAM.get();
                    if (targetAM.hasFaction()) {
                        String faction = targetAM.getFaction().toUpperCase();
                        return this.faction.contains(faction);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }
}

