/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.ai.Pathfinder;
import io.lumine.xikage.mythicmobs.mobs.ai.PathfinderAdapter;
import io.lumine.xikage.mythicmobs.mobs.ai.WrappedPathfinder;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;
import io.lumine.xikage.mythicmobs.util.reflections.VersionCompliantReflections;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileAIHandler;
import io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1.ai.CustomAIAdapter;
import io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1.ai.PathfinderHolder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityCreature;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityIronGolem;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityMonster;
import net.minecraft.server.v1_14_R1.EntitySkeleton;
import net.minecraft.server.v1_14_R1.EntityTameableAnimal;
import net.minecraft.server.v1_14_R1.EntityVillager;
import net.minecraft.server.v1_14_R1.EntityWolf;
import net.minecraft.server.v1_14_R1.IMonster;
import net.minecraft.server.v1_14_R1.IRangedEntity;
import net.minecraft.server.v1_14_R1.PathfinderGoal;
import net.minecraft.server.v1_14_R1.PathfinderGoalArrowAttack;
import net.minecraft.server.v1_14_R1.PathfinderGoalAvoidTarget;
import net.minecraft.server.v1_14_R1.PathfinderGoalBowShoot;
import net.minecraft.server.v1_14_R1.PathfinderGoalBreakDoor;
import net.minecraft.server.v1_14_R1.PathfinderGoalDoorOpen;
import net.minecraft.server.v1_14_R1.PathfinderGoalEatTile;
import net.minecraft.server.v1_14_R1.PathfinderGoalFleeSun;
import net.minecraft.server.v1_14_R1.PathfinderGoalFloat;
import net.minecraft.server.v1_14_R1.PathfinderGoalLeapAtTarget;
import net.minecraft.server.v1_14_R1.PathfinderGoalLookAtPlayer;
import net.minecraft.server.v1_14_R1.PathfinderGoalMeleeAttack;
import net.minecraft.server.v1_14_R1.PathfinderGoalMoveThroughVillage;
import net.minecraft.server.v1_14_R1.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.v1_14_R1.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.v1_14_R1.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.server.v1_14_R1.PathfinderGoalPanic;
import net.minecraft.server.v1_14_R1.PathfinderGoalRestrictSun;
import net.minecraft.server.v1_14_R1.PathfinderGoalSelector;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityTargetEvent;

public class VolatileAIHandler_v1_14_R1
implements VolatileAIHandler {
    private Reflector<EntityInsentient> refEntityInsentient = new Reflector<EntityInsentient>(EntityInsentient.class, "goalSelector", "targetSelector");
    private Reflector<PathfinderGoalSelector> refGoalSelector = new Reflector<PathfinderGoalSelector>(PathfinderGoalSelector.class, "c", "d");
    private final Map<String, Class<? extends PathfinderAdapter>> AI_GOALS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();
    private final Map<String, Class<? extends PathfinderAdapter>> AI_TARGETS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();

    public VolatileAIHandler_v1_14_R1(VolatileCodeHandler handler) {
        Set<Class<?>> customGoalClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.mobs.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : customGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] stringArray = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load custom AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> wrappedGoalClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : wrappedGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load wrapped AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.mobs.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load custom AI targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.volatilecode.v1_14_R1.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load wrapped AI targeter {0}", clazz.getCanonicalName());
            }
        }
    }

    @Override
    public void setTarget(LivingEntity entity, LivingEntity target) {
        if (entity instanceof Creature) {
            try {
                ((Creature)entity).setTarget(target);
            }
            catch (Exception exception) {}
        } else {
            try {
                ((EntityInsentient)((CraftLivingEntity)entity).getHandle()).setGoalTarget(((CraftLivingEntity)target).getHandle(), EntityTargetEvent.TargetReason.CUSTOM, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void navigateToLocation(AbstractEntity entity, AbstractLocation destination, double maxDistance) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        e.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), 1.0);
    }

    public void clearPathfinderGoals(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "goalSelector");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void clearPathfinderTargets(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "targetSelector");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void addPathfindersGoal(int index, AbstractEntity entity, PathfinderGoal goal, Predicate<AbstractEntity> validator) {
        block3: {
            if (validator != null && !validator.test(entity)) {
                return;
            }
            EntityInsentient nmsEntity = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
            PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(nmsEntity, "");
            try {
                goals.a(index, goal);
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to apply pathfinder goal");
                if (ConfigManager.debugLevel <= 0) break block3;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addPathfinderGoals(LivingEntity entity, List<String> aiMods) {
        block82: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "goalSelector");
                int i = 0;
                int j = 0;
                block64: for (String str : aiMods) {
                    String data2;
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : null;
                        data2 = split.length > 3 ? split[3] : null;
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : null;
                        data2 = split.length > 2 ? split[2] : null;
                    }
                    MythicLineConfig mlc = new MythicLineConfig(MythicLineConfig.unparseBlock(goal));
                    goal = mlc.getKey();
                    if (this.AI_GOALS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_GOALS.get(goal.toUpperCase());
                        try {
                            if (Pathfinder.class.isAssignableFrom(clazz)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((org.bukkit.entity.Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((org.bukkit.entity.Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            continue block64;
                        }
                        case "arrowattack": {
                            if (!(e instanceof IRangedEntity)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalArrowAttack((IRangedEntity)e, 1.0, 20, 60, 15.0f));
                            continue block64;
                        }
                        case "skeletonbowattack": 
                        case "bowshoot": 
                        case "bowmaster": {
                            if (!(e instanceof IRangedEntity)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBowShoot((EntityMonster)((EntitySkeleton)e), 1.0, 20, 15.0f));
                            continue block64;
                        }
                        case "breakdoor": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBreakDoor(e, p -> true));
                            continue block64;
                        }
                        case "eatgrass": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalEatTile(e));
                            continue block64;
                        }
                        case "fleegolems": 
                        case "runfromgolems": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityIronGolem.class, distance, 1.0, speed));
                            continue block64;
                        }
                        case "fleeplayers": 
                        case "runfromplayers": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityHuman.class, distance, 1.0, speed));
                            continue block64;
                        }
                        case "fleevillagers": 
                        case "runfromvillagers": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityVillager.class, distance, 1.0, speed));
                            continue block64;
                        }
                        case "fleewolves": 
                        case "runfromwolves": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            float distance = 6.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityWolf.class, distance, 1.0, speed));
                            continue block64;
                        }
                        case "fleesun": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFleeSun((EntityCreature)e, 1.0));
                            continue block64;
                        }
                        case "float": 
                        case "swim": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFloat(e));
                            continue block64;
                        }
                        case "gotoparent": {
                            try {
                                float distance = 4.0f;
                                if (data != null) {
                                    distance = Float.valueOf(data2).floatValue();
                                }
                                goals.a(j, (PathfinderGoal)new PathfinderGoalGoToParent(e, distance * distance));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block64;
                        }
                        case "lookatplayers": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLookAtPlayer(e, EntityHuman.class, 5.0f, 1.0f));
                            continue block64;
                        }
                        case "leapattarget": {
                            float speed = 0.3f;
                            if (data != null) {
                                speed = Float.valueOf(data).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLeapAtTarget(e, speed));
                            continue block64;
                        }
                        case "spiderattack": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalSpiderMeleeAttack((EntityCreature)e, EntityCreature.class));
                            continue block64;
                        }
                        case "movethroughvillage": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveThroughVillage((EntityCreature)e, 0.6, false, 4, () -> false));
                            continue block64;
                        }
                        case "movetowardsrestriction": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveTowardsRestriction((EntityCreature)e, 0.6));
                            continue block64;
                        }
                        case "opendoor": 
                        case "opendoors": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalDoorOpen(e, true));
                            continue block64;
                        }
                        case "panic": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalPanic((EntityCreature)e, 1.25));
                            continue block64;
                        }
                        case "patrol": 
                        case "patrolroute": {
                            try {
                                String[] split2;
                                ArrayList<AbstractLocation> points = new ArrayList<AbstractLocation>();
                                for (String s2 : split2 = data.split(";")) {
                                    String[] split3 = s2.split(",");
                                    int x = Integer.valueOf(split3[0]);
                                    int y = Integer.valueOf(split3[1]);
                                    int z = Integer.valueOf(split3[2]);
                                    AbstractLocation l = new AbstractLocation(BukkitAdapter.adapt(entity.getWorld()), x, y, z);
                                    points.add(l);
                                }
                                float speed2 = 1.0f;
                                if (data2 != null) {
                                    float f = Float.valueOf(data2).floatValue();
                                }
                                goals.a(j, (PathfinderGoal)new PathfinderGoalPatrolRoute(e, points, speed2));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block64;
                        }
                        case "restrictsun": {
                            if (!(e instanceof EntityCreature)) continue block64;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRestrictSun((EntityCreature)e));
                            continue block64;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error occurred while adding an AIGoalSelector, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block82;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addTargetGoals(LivingEntity entity, List<String> aiMods) {
        block37: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "targetSelector");
                int i = 0;
                int j = 0;
                block31: for (String str : aiMods) {
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : "";
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : "";
                    }
                    MythicLineConfig mlc = new MythicLineConfig(goal);
                    goal = mlc.getKey();
                    if (this.AI_TARGETS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_TARGETS.get(goal.toUpperCase());
                        try {
                            if (clazz.isAssignableFrom(Pathfinder.class)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((org.bukkit.entity.Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((org.bukkit.entity.Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            continue block31;
                        }
                        case "ownerhurttarget": 
                        case "ownertarget": {
                            if (!(e instanceof EntityTameableAnimal)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalOwnerHurtByTarget((EntityTameableAnimal)e));
                            continue block31;
                        }
                        case "monsters": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, entityliving -> entityliving instanceof IMonster));
                            continue block31;
                        }
                        case "players": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityHuman.class, true));
                            continue block31;
                        }
                        case "villagers": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityVillager.class, false));
                            continue block31;
                        }
                        case "iron_golems": 
                        case "golems": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityIronGolem.class, false));
                            continue block31;
                        }
                        case "otherfaction": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            String faction = data;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    UUID mobUUID = e.getUniqueID();
                                    UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                    Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                    if (!maybeMob.isPresent()) {
                                        return true;
                                    }
                                    ActiveMob am = maybeMob.get();
                                    if (am.hasFaction()) {
                                        return !MythicMobs.inst().getMobManager().getActiveMob(mobUUID).get().getFaction().equals(faction);
                                    }
                                    return true;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block31;
                        }
                        case "otherfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    if (targetEntity instanceof IMonster) {
                                        UUID mobUUID = e.getUniqueID();
                                        UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                        Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                        if (!maybeMob.isPresent()) {
                                            return true;
                                        }
                                        ActiveMob am = maybeMob.get();
                                        if (am.hasFaction()) {
                                            return !MythicMobs.inst().getMobManager().getActiveMob(mobUUID).get().getFaction().equals(am.getFaction());
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block31;
                        }
                        case "specificfaction": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            String faction = data;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    UUID mobUUID = e.getUniqueID();
                                    UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                    Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                    if (!maybeMob.isPresent()) {
                                        return true;
                                    }
                                    ActiveMob am = maybeMob.get();
                                    if (am.hasFaction()) {
                                        return am.getFaction().equals(faction);
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block31;
                        }
                        case "specificfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block31;
                            String faction = data;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    if (targetEntity instanceof IMonster) {
                                        UUID mobUUID = e.getUniqueID();
                                        UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                        Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                        if (!maybeMob.isPresent()) {
                                            return true;
                                        }
                                        ActiveMob am = maybeMob.get();
                                        if (am.hasFaction()) {
                                            return am.getFaction().equals(faction);
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block31;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error has occurred, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block37;
                ex.printStackTrace();
            }
        }
    }

    public class PathfinderGoalGoToParent
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;

        public PathfinderGoalGoToParent(EntityInsentient entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.a(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP));
        }

        public boolean a() {
            try {
                ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((org.bukkit.entity.Entity)((LivingEntity)this.entity.getBukkitEntity()));
                if (am.getParent() == null) {
                    return false;
                }
                org.bukkit.entity.Entity parent = BukkitAdapter.adapt(am.getParent().getEntity());
                if (parent == null || parent.isDead() || !parent.isValid()) {
                    return false;
                }
                AbstractLocation destination = BukkitAdapter.adapt(parent.getLocation());
                AbstractLocation eLocation = new AbstractLocation(destination.getWorld(), this.entity.locX, this.entity.locY, this.entity.locZ);
                if (eLocation.distanceSquared(destination) > 1024.0) {
                    am.getEntity().teleport(destination);
                    return true;
                }
                if (eLocation.distanceSquared(destination) > this.speed) {
                    this.entity.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), 1.0);
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntityCreature entity, Class<? extends Entity> oclass) {
            super(entity, 1.0, true);
        }

        public boolean b() {
            return super.b();
        }

        protected double a(EntityLiving entityliving) {
            return 4.0f + entityliving.getWidth();
        }
    }

    public class PathfinderGoalPatrolRoute
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;
        private AbstractWorld world;
        private int currentDestination = -1;
        private List<AbstractLocation> points;

        public PathfinderGoalPatrolRoute(EntityInsentient entity, List<AbstractLocation> points, double speed) {
            this.entity = entity;
            this.points = points;
            this.speed = speed;
            this.a(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP));
            if (points.size() == 0) {
                return;
            }
            this.world = points.get(0).getWorld();
            AbstractLocation entityLocation = new AbstractLocation(this.world, entity.locX, entity.locY, entity.locZ);
            int best = 0;
            double d = points.get(0).distanceSquared(entityLocation);
            for (int i = 1; i < points.size(); ++i) {
                double x = points.get(i).distanceSquared(entityLocation);
                if (!(x < d)) continue;
                best = i;
                d = x;
            }
            this.currentDestination = best;
        }

        public boolean a() {
            if (this.points.size() < 2) {
                return false;
            }
            AbstractLocation eLocation = new AbstractLocation(this.world, this.entity.locX, this.entity.locY, this.entity.locZ);
            AbstractLocation currentTarget = this.points.get(this.currentDestination);
            if (eLocation.distanceSquared(currentTarget) > 1.0) {
                this.entity.getNavigation().a(currentTarget.getX(), currentTarget.getY(), currentTarget.getZ(), this.speed);
                return true;
            }
            if (++this.currentDestination == this.points.size()) {
                this.currentDestination = 0;
            }
            AbstractLocation newTarget = this.points.get(this.currentDestination);
            this.entity.getNavigation().a(newTarget.getX(), newTarget.getY(), newTarget.getZ(), this.speed);
            return true;
        }
    }
}

