/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_13_R2;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileWorldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.Block;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.Chunk;
import net.minecraft.server.v1_13_R2.DifficultyDamageScaler;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityArmorStand;
import net.minecraft.server.v1_13_R2.EntityFallingBlock;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.IBlockAccess;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.IWorldAccess;
import net.minecraft.server.v1_13_R2.MathHelper;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_13_R2.ParticleParam;
import net.minecraft.server.v1_13_R2.SoundCategory;
import net.minecraft.server.v1_13_R2.SoundEffect;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VolatileWorldHandler_v1_13_R2
implements VolatileWorldHandler {
    private final Map<org.bukkit.World, IWorldAccess> worldAccessMap = new HashMap<org.bukkit.World, IWorldAccess>();
    Reflector<World> worldAccessList = new Reflector<World>(World.class, "v");

    public VolatileWorldHandler_v1_13_R2(VolatileCodeHandler handler) {
    }

    @Override
    public void registerWorldAccess(org.bukkit.World world) {
        if (this.worldAccessMap.containsKey(world)) {
            this.unregisterWorldAccess(world);
        }
        IWorldAccess nmsWorldAccess = new IWorldAccess(){

            public void a(IBlockAccess iBlockAccess, BlockPosition blockPosition, IBlockData iBlockData, IBlockData iBlockData1, int i) {
            }

            public void a(BlockPosition blockPosition) {
            }

            public void a(int i, int i1, int i2, int i3, int i4, int i5) {
            }

            public void a(@Nullable EntityHuman entityHuman, SoundEffect soundEffect, SoundCategory soundCategory, double v, double v1, double v2, float v3, float v4) {
            }

            public void a(SoundEffect soundEffect, BlockPosition blockPosition) {
            }

            public void a(ParticleParam particleParam, boolean b, double v, double v1, double v2, double v3, double v4, double v5) {
            }

            public void a(ParticleParam particleParam, boolean b, boolean b1, double v, double v1, double v2, double v3, double v4, double v5) {
            }

            public void a(Entity entity) {
            }

            public void b(Entity entity) {
                MythicMobs.inst().getMobManager().setEntityDespawned(entity.getBukkitEntity().getUniqueId());
            }

            public void a(int i, BlockPosition blockPosition, int i1) {
            }

            public void a(EntityHuman entityHuman, int i, BlockPosition blockPosition, int i1) {
            }

            public void b(int i, BlockPosition blockPosition, int i1) {
            }
        };
        this.worldAccessMap.put(world, nmsWorldAccess);
        ((CraftWorld)world).getHandle().addIWorldAccess(nmsWorldAccess);
    }

    @Override
    public void unregisterWorldAccess(org.bukkit.World world) {
        if (!this.worldAccessMap.containsKey(world)) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        List list = (List)this.worldAccessList.get((World)nmsWorld, "v");
        if (list != null) {
            list.remove(this.worldAccessMap.get(world));
        }
        this.worldAccessMap.remove(world);
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        for (Player player : l.getWorld().getPlayers()) {
            player.playSound(l, sound, volume, pitch);
        }
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkIfLoaded(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
        if (chunk == null) {
            return 0;
        }
        int amount = 0;
        for (List slice : chunk.getEntitySlices()) {
            amount += slice.size();
        }
        return amount;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.getType(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        EntityFallingBlock block = new EntityFallingBlock((World)nmsWorld, (double)target.getBlockX() + 0.5, (double)(target.getBlockY() + 1), (double)target.getBlockZ() + 0.5, blockState);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((Entity)block, Block.getCombinedId((IBlockData)blockState));
        PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.getId(), velocity.getX(), velocity.getY(), velocity.getZ());
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (hideSourceBlock) {
                p.sendBlockChange(location, Material.AIR, (byte)0);
            }
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet);
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packetV);
            Scheduler.runLaterAsync(() -> {
                PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.getId()});
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet2);
                if (hideSourceBlock) {
                    p.sendBlockChange(location, location.getBlock().getType(), (byte)0);
                }
            }, duration);
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = MathHelper.floor((double)((location.getX() - radius) / 16.0));
        int bigX = MathHelper.floor((double)((location.getX() + radius) / 16.0));
        int smallZ = MathHelper.floor((double)((location.getZ() - radius) / 16.0));
        int bigZ = MathHelper.floor((double)((location.getZ() + radius) / 16.0));
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
                if (null == chunk) continue;
                for (List slice : chunk.getEntitySlices()) {
                    for (Entity e : slice) {
                        AbstractEntity entity = BukkitAdapter.adapt((org.bukkit.entity.Entity)e.getBukkitEntity());
                        if (predicate != null && !predicate.test(entity)) continue;
                        entities.add(entity);
                    }
                }
            }
        }
        return entities;
    }

    @Override
    public org.bukkit.entity.Entity spawnInvisibleArmorStand(Location location) {
        WorldServer w = ((CraftWorld)location.getWorld()).getHandle();
        EntityArmorStand nmsEntity = new EntityArmorStand((World)w, location.getX(), location.getY(), location.getZ());
        nmsEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        nmsEntity.setInvisible(true);
        w.addEntity((Entity)nmsEntity);
        return nmsEntity.getBukkitEntity();
    }
}

