/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_13_R2;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.xikage.mythicmobs.volatilecode.v1_13_R2.CompoundTag_v1_13_R2;
import java.util.HashSet;
import net.minecraft.server.v1_13_R2.ChatComponentText;
import net.minecraft.server.v1_13_R2.ChatMessageType;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityArmorStand;
import net.minecraft.server.v1_13_R2.EntityInsentient;
import net.minecraft.server.v1_13_R2.EntityItem;
import net.minecraft.server.v1_13_R2.EntityLightning;
import net.minecraft.server.v1_13_R2.EntityLiving;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutChat;
import net.minecraft.server.v1_13_R2.PacketPlayOutCloseWindow;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_13_R2.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_13_R2.PacketPlayOutPosition;
import net.minecraft.server.v1_13_R2.PacketPlayOutSetSlot;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntityWeather;
import net.minecraft.server.v1_13_R2.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_13_R2.PlayerConnection;
import net.minecraft.server.v1_13_R2.WorldBorder;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class VolatileEntityHandler_v1_13_R2
implements VolatileEntityHandler {
    public VolatileEntityHandler_v1_13_R2(VolatileCodeHandler handler) {
    }

    @Override
    public void setEntityAbsorptionHearts(AbstractEntity entity, float value) {
        if (!entity.isLiving()) {
            return;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        el.setAbsorptionHearts(value);
    }

    @Override
    public float getEntityAbsorptionHearts(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return 0.0f;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        return el.getAbsorptionHearts();
    }

    @Override
    public void setLocation(AbstractEntity entity, AbstractLocation location) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.setLocation(x, y, z, yaw, pitch);
        if (entity.isPlayer()) {
            this.playerConnectionTeleport(entity, x, y, z, yaw, pitch, noRotation, noGravity);
        }
        e.world.entityJoinedWorld(e, false);
    }

    private void playerConnectionTeleport(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        if (noRotation) {
            pitch = 0.0f;
            yaw = 0.0f;
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.X_ROT);
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y_ROT);
        }
        if (noGravity) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y);
            y = 0.0;
        }
        me.playerConnection.sendPacket((Packet)new PacketPlayOutPosition(x, y, z, yaw, pitch, set, 0));
    }

    @Override
    public boolean isEntityInMotion(AbstractEntity entity, boolean exact) {
        if (entity.isLiving()) {
            EntityInsentient e = (EntityInsentient)((CraftEntity)entity.getBukkitEntity()).getHandle();
            if (e.lastX != e.locX || e.lastY != e.locY || e.lastZ != e.locZ) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setHitBox(AbstractEntity target, double a0, double a1, double a2) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        me.getBoundingBox().a(a0, a1, a2);
    }

    @Override
    public void setItemPosition(AbstractEntity target, AbstractLocation ol) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        if (entity instanceof Item) {
            Item item = (Item)entity;
            EntityItem ei = (EntityItem)((CraftItem)item).getHandle();
            ei.setPosition(ol.getX(), ol.getY(), ol.getZ());
        }
    }

    @Override
    public void sendEntityTeleportPacket(AbstractEntity target) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        PacketPlayOutEntityTeleport tp = new PacketPlayOutEntityTeleport(me);
        entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), 32.0, 32.0, 32.0).forEach(e -> {
            if (e instanceof Player) {
                ((CraftPlayer)e).getHandle().playerConnection.sendPacket((Packet)tp);
            }
        });
    }

    @Override
    public void setEntityRotation(AbstractEntity target, float pitch, float yaw) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        me.pitch = pitch;
        me.yaw = yaw;
    }

    @Override
    public void setEntityPitch(AbstractEntity target, float pitch) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        me.pitch = pitch;
    }

    @Override
    public void setArmorStandNoGravity(AbstractEntity target) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        if (entity.getType() == EntityType.ARMOR_STAND) {
            EntityArmorStand as = (EntityArmorStand)((CraftEntity)entity).getHandle();
            as.setNoGravity(true);
        }
    }

    @Override
    public void forcePlayCredits(AbstractPlayer target, float f) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(4, f));
    }

    @Override
    public void forceCloseWindow(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.playerConnection.sendPacket((Packet)new PacketPlayOutCloseWindow(0));
    }

    @Override
    public void setPlayerWorldBorder(AbstractPlayer target, AbstractLocation center, int radius) {
        WorldBorder border;
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (radius == -1) {
            border = ep.world.getWorldBorder();
        } else {
            border = new WorldBorder();
            border.world = ep.world.getWorldBorder().world;
            border.setCenter(center.getX(), center.getZ());
            border.setSize((double)radius);
            border.setWarningDistance(1);
        }
        ep.playerConnection.sendPacket((Packet)new PacketPlayOutWorldBorder(border, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    @Override
    public void sendPlayerFakeInventoryItem(AbstractPlayer target, org.bukkit.inventory.ItemStack stack, int slot) {
        if (slot < 9) {
            slot += 36;
        }
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        ItemStack item = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)stack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(0, slot, item);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void setEntitySpawnReason(AbstractEntity target, CreatureSpawnEvent.SpawnReason reason) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        World world = BukkitAdapter.adapt(target.getWorld());
        Entity entityHandle = ((CraftEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        worldHandle.addEntity(entityHandle, reason);
    }

    @Override
    public AbstractEntity addNBTData(AbstractEntity entity, String key, Tag value) {
        CompoundTag compound = this.getNBTData(entity).createBuilder().put(key, value).build();
        this.setNBTData(entity, compound);
        return entity;
    }

    @Override
    public CompoundTag getNBTData(AbstractEntity entity) {
        org.bukkit.entity.Entity bukkitEntity = entity.getBukkitEntity();
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)bukkitEntity).getHandle().c(compound);
        return CompoundTag_v1_13_R2.fromNMSTag(compound);
    }

    @Override
    public AbstractEntity setNBTData(AbstractEntity entity, CompoundTag compoundTag) {
        org.bukkit.entity.Entity bukkitEntity = entity.getBukkitEntity();
        ((CraftEntity)bukkitEntity).getHandle().f(((CompoundTag_v1_13_R2)compoundTag).toNMSTag());
        return entity;
    }

    @Override
    public void sendGameStateChange(AbstractPlayer target, int state, int skybox) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(state, (float)skybox);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void sendActionBarMessageToPlayer(AbstractPlayer target, String message) {
        Player player = BukkitAdapter.adapt(target);
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        PacketPlayOutChat packet = new PacketPlayOutChat((IChatBaseComponent)new ChatComponentText(message), ChatMessageType.GAME_INFO);
        conn.sendPacket((Packet)packet);
    }

    @Override
    public void spawnFakeLightning(AbstractLocation target, double radius) {
        Location location = BukkitAdapter.adapt(target);
        double distanceSquared = Math.pow(radius, 2.0);
        for (Player p : location.getWorld().getPlayers()) {
            if (!(location.distanceSquared(p.getLocation()) <= distanceSquared)) continue;
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutSpawnEntityWeather((Entity)new EntityLightning(((CraftPlayer)p).getHandle().getWorld(), location.getX(), location.getY(), location.getZ(), false, false)));
            p.playSound(location, "entity.lightning.thunder", 10000.0f, 63.0f);
        }
    }
}

