/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.ai.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ai.WrappedPathfindingGoal;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.ai.PathfinderHolder;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.PathfinderGoal;
import net.minecraft.server.v1_12_R1.PathfinderGoalNearestAttackableTarget;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="nearestConditionalTarget", aliases={"nearestConditional", "nearestIf"}, description="Target a nearby attacker that meets the conditions", premium=true)
public class NearestConditionalTargetGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    protected String targetConditionString;
    protected List<SkillCondition> targetConditions = null;

    public NearestConditionalTargetGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (this.targetConditionString != null) {
            this.targetConditions = NearestConditionalTargetGoal.getPlugin().getSkillManager().getConditions(this.targetConditionString);
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        EntityInsentient e = PathfinderHolder.getNMSEntity(this.entity);
        return new PathfinderGoalNearestAttackableTarget((EntityCreature)e, EntityInsentient.class, 0, true, false, targetEntity -> {
            try {
                AbstractEntity absEntity = BukkitAdapter.adapt((Entity)((EntityInsentient)targetEntity).getBukkitEntity());
                for (SkillCondition cond : this.targetConditions) {
                    if (cond.evaluateToEntity(this.entity, absEntity)) continue;
                    return false;
                }
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
            return true;
        });
    }
}

