/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.util.VectorUtils;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileAIHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileBlockHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileItemHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileWorldHandler;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.CompoundTag_v1_12_R1;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.VolatileAIHandler_v1_12_R1;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.VolatileBlockHandler_v1_12_R1;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.VolatileEntityHandler_v1_12_R1;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.VolatileItemHandler_v1_12_R1;
import io.lumine.xikage.mythicmobs.volatilecode.v1_12_R1.VolatileWorldHandler_v1_12_R1;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.CommandAbstract;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityChicken;
import net.minecraft.server.v1_12_R1.EntityFireworks;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.ICommandListener;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutResourcePackSend;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class VolatileCodeEnabled_v1_12_R1
implements VolatileCodeHandler {
    private final VolatileAIHandler AIHandler = new VolatileAIHandler_v1_12_R1(this);
    private final VolatileBlockHandler blockHandler = new VolatileBlockHandler_v1_12_R1(this);
    private final VolatileEntityHandler entityHandler = new VolatileEntityHandler_v1_12_R1(this);
    private final VolatileItemHandler itemHandler = new VolatileItemHandler_v1_12_R1(this);
    private final VolatileWorldHandler worldHandler = new VolatileWorldHandler_v1_12_R1(this);
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.BAT, new EntityType[]{EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.HORSE, EntityType.MAGMA_CUBE, EntityType.POLAR_BEAR, EntityType.SILVERFISH, EntityType.SLIME});

    @Override
    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTag_v1_12_R1(value);
    }

    @Override
    public Set<AbstractEntity> getEntitiesBySelector(SkillCaster am, String targetSelector) {
        List targets;
        net.minecraft.server.v1_12_R1.Entity CL = ((CraftEntity)BukkitAdapter.adapt(am.getEntity())).getHandle();
        try {
            MinecraftServer ms = MinecraftServer.getServer();
            targets = CommandAbstract.d((MinecraftServer)ms, (ICommandListener)CL, (String)targetSelector);
        }
        catch (Exception ex) {
            targets = Collections.emptyList();
            ex.printStackTrace();
        }
        HashSet<AbstractEntity> ftargets = new HashSet<AbstractEntity>();
        for (net.minecraft.server.v1_12_R1.Entity target : targets) {
            ftargets.add(BukkitAdapter.adapt((Entity)target.getBukkitEntity()));
        }
        return ftargets;
    }

    @Override
    public void CreateFireworksExplosion(Location loc, boolean flicker, boolean trail, int type, int[] colors, int[] fadeColors, int flightDuration) {
        ItemStack item = new ItemStack(Item.getById((int)401), 1, 0);
        NBTTagCompound tag = item.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound explTag = new NBTTagCompound();
        explTag.setByte("Flicker", flicker ? (byte)1 : 0);
        explTag.setByte("Trail", trail ? (byte)1 : 0);
        explTag.setByte("Type", (byte)type);
        explTag.setIntArray("Colors", colors);
        explTag.setIntArray("FadeColors", fadeColors);
        NBTTagCompound fwTag = new NBTTagCompound();
        fwTag.setByte("Flight", (byte)flightDuration);
        NBTTagList explList = new NBTTagList();
        explList.add((NBTBase)explTag);
        fwTag.set("Explosions", (NBTBase)explList);
        tag.set("Fireworks", (NBTBase)fwTag);
        item.setTag(tag);
        EntityFireworks fireworks = new EntityFireworks((World)((CraftWorld)loc.getWorld()).getHandle(), loc.getX(), loc.getY(), loc.getZ(), item);
        ((CraftWorld)loc.getWorld()).getHandle().addEntity((net.minecraft.server.v1_12_R1.Entity)fireworks);
        if (flightDuration == 0) {
            ((CraftWorld)loc.getWorld()).getHandle().broadcastEntityEffect((net.minecraft.server.v1_12_R1.Entity)fireworks, (byte)17);
            fireworks.die();
        }
    }

    @Override
    public void setChickenHostile(Chicken c) {
        EntityChicken chicken = ((CraftChicken)c).getHandle();
        chicken.o(true);
    }

    @Override
    public void doDamage(ActiveMob mob, AbstractEntity t, float amount) {
        CraftLivingEntity caster = (CraftLivingEntity)mob.getEntity().getBukkitEntity();
        CraftLivingEntity target = (CraftLivingEntity)t.getBukkitEntity();
        target.getHandle().damageEntity(DamageSource.mobAttack((EntityLiving)caster.getHandle()), amount);
    }

    @Override
    public double getAbsorptionHearts(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().getAbsorptionHearts();
    }

    @Override
    public void saveSkinData(Player player, String name) {
        block3: {
            GameProfile profile = ((CraftPlayer)player).getHandle().getProfile();
            Collection props = profile.getProperties().get((Object)"textures");
            Iterator iterator = props.iterator();
            if (!iterator.hasNext()) break block3;
            Property prop = (Property)iterator.next();
            String skin = prop.getValue();
            String sig = prop.getSignature();
            File folder = new File(MythicMobs.inst().getDataFolder(), "PlayerSkins");
            if (!folder.exists()) {
                folder.mkdir();
            }
            File skinFile = new File(folder, name + ".skin.txt");
            File sigFile = new File(folder, name + ".sig.txt");
            try {
                FileWriter writer = new FileWriter(skinFile);
                writer.write(skin);
                writer.flush();
                writer.close();
                writer = new FileWriter(sigFile);
                writer.write(sig);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public float getItemRecharge(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.n(0.0f);
    }

    @Override
    public boolean getItemRecharging(Player player) {
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        return ep.n(0.0f) < 1.0f;
    }

    @Override
    public void doEffectArmSwing(AbstractEntity entity) {
        net.minecraft.server.v1_12_R1.Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.getWorld().broadcastEntityEffect(e, (byte)4);
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    @Override
    public void lookAt(AbstractEntity entity, float yaw, float pitch) {
        net.minecraft.server.v1_12_R1.Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        handle.yaw = yaw = VectorUtils.clampYaw(yaw);
        this.setHeadYaw(entity, yaw);
        handle.pitch = pitch;
    }

    @Override
    public void lookAtLocation(AbstractEntity entity, AbstractLocation to, boolean headOnly, boolean immediate) {
        net.minecraft.server.v1_12_R1.Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient)) {
            AbstractLocation fromLocation = entity.getLocation();
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw -= 90.0;
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.lookAt(entity, (float)yaw, (float)pitch);
            }
        } else {
            ((EntityInsentient)handle).getControllerLook().a(to.getX(), to.getY(), to.getZ(), (float)((EntityInsentient)handle).O(), (float)((EntityInsentient)handle).N());
            while (((EntityLiving)handle).aP >= 180.0f) {
                ((EntityLiving)handle).aP -= 360.0f;
            }
            while (((EntityLiving)handle).aP < -180.0f) {
                ((EntityLiving)handle).aP += 360.0f;
            }
        }
    }

    @Override
    public void lookAtEntity(AbstractEntity entity, AbstractEntity to, boolean headOnly, boolean immediate) {
        net.minecraft.server.v1_12_R1.Entity handle = ((CraftEntity)BukkitAdapter.adapt(entity)).getHandle();
        net.minecraft.server.v1_12_R1.Entity target = ((CraftEntity)BukkitAdapter.adapt(to)).getHandle();
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType())) {
            if (to.isLiving()) {
                this.lookAtLocation(entity, to.getEyeLocation(), headOnly, immediate);
            } else {
                this.lookAtLocation(entity, to.getLocation(), headOnly, immediate);
            }
        } else if (handle instanceof EntityInsentient) {
            EntityInsentient insentient = (EntityInsentient)handle;
            insentient.getControllerLook().a(target, (float)insentient.O(), (float)insentient.N());
            while (insentient.aP >= 180.0f) {
                insentient.aP -= 360.0f;
            }
            while (((EntityLiving)handle).aP < -180.0f) {
                insentient.aP += 360.0f;
            }
        }
    }

    @Override
    public void applyPhysics(Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        net.minecraft.server.v1_12_R1.Block block = iblockdata.getBlock();
        world.applyPhysics(blockposition, block, true);
    }

    @Override
    public void sendResourcePack(AbstractPlayer player, String url, String hash) {
        EntityPlayer p = ((CraftPlayer)player.getBukkitEntity()).getHandle();
        p.playerConnection.sendPacket((Packet)new PacketPlayOutResourcePackSend(url, hash));
    }

    @Override
    public VolatileAIHandler getAIHandler() {
        return this.AIHandler;
    }

    @Override
    public VolatileBlockHandler getBlockHandler() {
        return this.blockHandler;
    }

    @Override
    public VolatileEntityHandler getEntityHandler() {
        return this.entityHandler;
    }

    @Override
    public VolatileItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public VolatileWorldHandler getWorldHandler() {
        return this.worldHandler;
    }
}

