/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.common.base.Preconditions;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonBuilder;
import io.lumine.xikage.mythicmobs.utils.gson.JsonElement;
import io.lumine.xikage.mythicmobs.utils.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import io.lumine.xikage.mythicmobs.utils.serialize.Region;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public final class Zone
implements GsonSerializable {
    private final Locus min;
    private final Locus max;
    private final double width;
    private final double height;
    private final double depth;

    public static Zone deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("min"));
        Preconditions.checkArgument(object.has("max"));
        Locus a = Locus.deserialize(object.get("min"));
        Locus b = Locus.deserialize(object.get("max"));
        return Zone.of(a, b);
    }

    public static Zone of(Locus a, Locus b) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        return new Zone(a, b);
    }

    private Zone(Locus a, Locus b) {
        this.min = Locus.of(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()));
        this.max = Locus.of(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()));
        this.width = this.max.getX() - this.min.getX();
        this.height = this.max.getY() - this.min.getY();
        this.depth = this.max.getZ() - this.min.getZ();
    }

    public boolean inRegion(Position pos) {
        Objects.requireNonNull(pos, "pos");
        return this.inRegion(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean inRegion(Location loc) {
        Objects.requireNonNull(loc, "loc");
        return this.inRegion(loc.getX(), loc.getY(), loc.getZ());
    }

    public boolean inRegion(double x, double y, double z) {
        return x >= this.min.getX() && x <= this.max.getX() && y >= this.min.getY() && y <= this.max.getY() && z >= this.min.getZ() && z <= this.max.getZ();
    }

    public boolean inBlockRegion(Position pos) {
        Objects.requireNonNull(pos, "pos");
        Location loc = pos.toLocation();
        return this.inRegion(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public boolean inBlockRegion(Location loc) {
        Objects.requireNonNull(loc, "loc");
        return this.inRegion(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Region toRegion(String world) {
        return this.toRegion(Bukkit.getWorld((String)world));
    }

    public Region toRegion(World world) {
        return Region.of(this.min.toPosition(world), this.max.toPosition(world));
    }

    public Locus getMin() {
        return this.min;
    }

    public Locus getMax() {
        return this.max;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("min", this.min).add("max", this.max).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone other = (Zone)o;
        return this.getMin().equals(other.getMin()) && this.getMax().equals(other.getMax());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMin().hashCode();
        result = result * 59 + this.getMax().hashCode();
        return result;
    }

    public String toString() {
        return "Zone(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }
}

