/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.common.base.Preconditions;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonBuilder;
import io.lumine.xikage.mythicmobs.utils.gson.JsonElement;
import io.lumine.xikage.mythicmobs.utils.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockLocus;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockPosition;
import io.lumine.xikage.mythicmobs.utils.serialize.Direction;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import io.lumine.xikage.mythicmobs.utils.serialize.Point;
import io.lumine.xikage.mythicmobs.utils.serialize.Region;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public final class Position
implements GsonSerializable {
    private final double x;
    private final double y;
    private final double z;
    private final String world;
    @Nullable
    private Location bukkitLocation = null;

    public static Position deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("x"));
        Preconditions.checkArgument(object.has("y"));
        Preconditions.checkArgument(object.has("z"));
        Preconditions.checkArgument(object.has("world"));
        double x = object.get("x").getAsDouble();
        double y = object.get("y").getAsDouble();
        double z = object.get("z").getAsDouble();
        String world = object.get("world").getAsString();
        return Position.of(x, y, z, world);
    }

    public static Position of(double x, double y, double z, String world) {
        Objects.requireNonNull(world, "world");
        return new Position(x, y, z, world);
    }

    public static Position of(double x, double y, double z, World world) {
        Objects.requireNonNull(world, "world");
        return Position.of(x, y, z, world.getName());
    }

    public static Position of(Location location) {
        Objects.requireNonNull(location, "location");
        return Position.of(location.getX(), location.getY(), location.getZ(), location.getWorld().getName());
    }

    public static Position of(Block block) {
        Objects.requireNonNull(block, "block");
        return Position.of(block.getLocation());
    }

    private Position(double x, double y, double z, String world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public synchronized Location toLocation() {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z);
        }
        return this.bukkitLocation.clone();
    }

    public synchronized Locus toLocus() {
        return Locus.of(this.x, this.y, this.z);
    }

    public synchronized BlockLocus toBlockLocus() {
        return BlockLocus.of((int)this.x, (int)this.y, (int)this.z);
    }

    public BlockPosition floor() {
        return BlockPosition.of(Position.bukkitFloor(this.x), Position.bukkitFloor(this.y), Position.bukkitFloor(this.z), this.world);
    }

    public Position getRelative(BlockFace face) {
        Objects.requireNonNull(face, "face");
        return Position.of(this.x + (double)face.getModX(), this.y + (double)face.getModY(), this.z + (double)face.getModZ(), this.world);
    }

    public Position getRelative(BlockFace face, double distance) {
        Objects.requireNonNull(face, "face");
        return Position.of(this.x + (double)face.getModX() * distance, this.y + (double)face.getModY() * distance, this.z + (double)face.getModZ() * distance, this.world);
    }

    public Position add(Vector vector3i) {
        return this.add(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Position add(double x, double y, double z) {
        return Position.of(this.x + x, this.y + y, this.z + z, this.world);
    }

    public Position subtract(Vector vector3i) {
        return this.subtract(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Position subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Region regionWith(Position other) {
        Objects.requireNonNull(other, "other");
        return Region.of(this, other);
    }

    public Point withDirection(Direction direction) {
        return Point.of(this, direction);
    }

    public Position transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.x - aboutX;
        double z = this.z - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return Position.of(x2 + aboutX + translateX, this.y, z2 + aboutZ + translateZ, this.world);
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("y", this.y).add("z", this.z).add("world", this.world).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return Double.compare(this.getX(), other.getX()) == 0 && Double.compare(this.getY(), other.getY()) == 0 && Double.compare(this.getZ(), other.getZ()) == 0 && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long x = Double.doubleToLongBits(this.getX());
        long y = Double.doubleToLongBits(this.getY());
        long z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)(x >>> 32 ^ x);
        result = result * 59 + (int)(y >>> 32 ^ y);
        result = result * 59 + (int)(z >>> 32 ^ z);
        result = result * 59 + this.getWorld().hashCode();
        return result;
    }

    public String toString() {
        return "Position(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", world=" + this.getWorld() + ")";
    }

    private static int bukkitFloor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }
}

