/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.profiles;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.gson.stream.JsonReader;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.uuid.UndashedUUIDs;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Deprecated
public final class MojangApi {
    public static final String PROFILES_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    public static final String NAME_HISTORY_URL = "https://api.mojang.com/user/profiles/%s/names";

    public static Promise<UUID> usernameToUuid(String username) {
        Objects.requireNonNull(username, "username");
        if (username.isEmpty()) {
            throw new IllegalArgumentException("empty");
        }
        return Schedulers.async().supply(() -> {
            UUID uUID;
            JsonReader reader = new JsonReader(new InputStreamReader(new URL(String.format(PROFILES_URL, username)).openConnection().getInputStream()));
            try {
                reader.beginObject();
                reader.skipValue();
                uUID = UndashedUUIDs.fromString(reader.nextString());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            reader.close();
            return uUID;
        });
    }

    public static Promise<String> uuidToUsername(UUID uuid) {
        return MojangApi.getUsernameHistory(uuid).thenApplyAsync(names -> names.isEmpty() ? null : (String)names.get(names.size() - 1));
    }

    public static Promise<List<String>> getUsernameHistory(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return Schedulers.async().supply(() -> {
            ArrayList<String> names = Lists.newArrayList();
            try (JsonReader reader = new JsonReader(new InputStreamReader(new URL(String.format(NAME_HISTORY_URL, UndashedUUIDs.toString(uuid))).openConnection().getInputStream()));){
                reader.beginArray();
                int i = 0;
                while (reader.hasNext()) {
                    reader.beginObject();
                    reader.skipValue();
                    names.add(reader.nextString());
                    if (i != 0) {
                        reader.skipValue();
                        reader.skipValue();
                    }
                    reader.endObject();
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return names;
        });
    }

    private MojangApi() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

