/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.network.bungee;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.lumine.xikage.mythicmobs.utils.Players;
import io.lumine.xikage.mythicmobs.utils.annotation.NonnullByDefault;
import io.lumine.xikage.mythicmobs.utils.network.bungee.BungeeCord;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

@NonnullByDefault
public final class BungeeCordImpl
implements BungeeCord,
PluginMessageListener {
    private static final String CHANNEL = "BungeeCord";
    private final LuminePlugin plugin;
    private final AtomicBoolean setup = new AtomicBoolean(false);
    private final List<MessageCallback> listeners = new LinkedList<MessageCallback>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Set<MessageAgent> queuedMessages = ConcurrentHashMap.newKeySet();

    public BungeeCordImpl(LuminePlugin plugin) {
        this.plugin = plugin;
    }

    private void ensureSetup() {
        if (!this.setup.compareAndSet(false, true)) {
            return;
        }
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (!channel.equals(CHANNEL)) {
            return;
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        ByteArrayDataInput in = ByteStreams.newDataInput(byteIn);
        String subChannel = in.readUTF();
        byteIn.mark(0);
        this.lock.lock();
        try {
            Iterator<MessageCallback> it = this.listeners.iterator();
            while (it.hasNext()) {
                MessageCallback e = it.next();
                if (!e.getSubChannel().equals(subChannel)) continue;
                byteIn.reset();
                boolean accepted = e.testResponse(player, in);
                if (!accepted) continue;
                byteIn.reset();
                boolean shouldRemove = e.acceptResponse(player, in);
                if (!shouldRemove) continue;
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sendMessage(MessageAgent agent) {
        Player player = agent.getHandle();
        if (player != null) {
            if (!player.isOnline()) {
                throw new IllegalStateException("Player not online");
            }
            this.sendToChannel(agent, player);
            return;
        }
        player = Iterables.getFirst(Players.all(), null);
        if (player != null) {
            this.sendToChannel(agent, player);
        } else {
            this.queuedMessages.add(agent);
            this.ensureSetup();
        }
    }

    private void flushQueuedMessages() {
        if (this.queuedMessages.isEmpty()) {
            return;
        }
        Player p = Iterables.getFirst(Players.all(), null);
        if (p != null) {
            this.queuedMessages.removeIf(ma -> {
                this.sendToChannel((MessageAgent)ma, p);
                return true;
            });
        }
    }

    private void sendToChannel(MessageAgent agent, Player player) {
        this.ensureSetup();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(agent.getSubChannel());
        agent.appendPayload(out);
        byte[] buf = out.toByteArray();
        player.sendPluginMessage((Plugin)this.plugin, CHANNEL, buf);
        if (agent instanceof MessageCallback) {
            MessageCallback callback = (MessageCallback)((Object)agent);
            this.registerCallback(callback);
        }
    }

    private void registerCallback(MessageCallback callback) {
        this.ensureSetup();
        this.lock.lock();
        try {
            this.listeners.add(callback);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connect(Player player, String serverName) {
        this.sendMessage(new ConnectAgent(player, serverName));
    }

    @Override
    public void connectOther(String playerName, String serverName) {
        this.sendMessage(new ConnectOtherAgent(playerName, serverName));
    }

    @Override
    public Promise<Map.Entry<String, Integer>> ip(Player player) {
        Promise<Map.Entry<String, Integer>> fut = Promise.empty();
        this.sendMessage(new IPAgent(player, fut));
        return fut;
    }

    @Override
    public Promise<Integer> playerCount(String serverName) {
        Promise<Integer> fut = Promise.empty();
        this.sendMessage(new PlayerCountAgent(serverName, fut));
        return fut;
    }

    @Override
    public Promise<List<String>> playerList(String serverName) {
        Promise<List<String>> fut = Promise.empty();
        this.sendMessage(new PlayerListAgent(serverName, fut));
        return fut;
    }

    @Override
    public Promise<List<String>> getServers() {
        Promise<List<String>> fut = Promise.empty();
        this.sendMessage(new GetServersAgent(fut));
        return fut;
    }

    @Override
    public void message(String playerName, String message) {
        this.sendMessage(new PlayerMessageAgent(playerName, message));
    }

    @Override
    public Promise<String> getServer() {
        Promise<String> fut = Promise.empty();
        this.sendMessage(new GetServerAgent(fut));
        return fut;
    }

    @Override
    public Promise<UUID> uuid(Player player) {
        Promise<UUID> fut = Promise.empty();
        this.sendMessage(new UUIDAgent(player, fut));
        return fut;
    }

    @Override
    public Promise<UUID> uuidOther(String playerName) {
        Promise<UUID> fut = Promise.empty();
        this.sendMessage(new UUIDOtherAgent(playerName, fut));
        return fut;
    }

    @Override
    public Promise<Map.Entry<String, Integer>> serverIp(String serverName) {
        Promise<Map.Entry<String, Integer>> fut = Promise.empty();
        this.sendMessage(new ServerIPAgent(serverName, fut));
        return fut;
    }

    @Override
    public void kickPlayer(String playerName, String reason) {
        this.sendMessage(new KickPlayerAgent(playerName, reason));
    }

    @Override
    public void forward(String serverName, String channelName, byte[] data) {
        this.sendMessage(new ForwardAgent(serverName, channelName, data));
    }

    @Override
    public void forward(String serverName, String channelName, ByteArrayDataOutput data) {
        this.sendMessage(new ForwardAgent(serverName, channelName, data));
    }

    @Override
    public void forwardToPlayer(String playerName, String channelName, byte[] data) {
        this.sendMessage(new ForwardToPlayerAgent(playerName, channelName, data));
    }

    @Override
    public void forwardToPlayer(String playerName, String channelName, ByteArrayDataOutput data) {
        this.sendMessage(new ForwardToPlayerAgent(playerName, channelName, data));
    }

    @Override
    public void registerForwardCallbackRaw(String channelName, Predicate<byte[]> callback) {
        ForwardCustomCallback customCallback = new ForwardCustomCallback(channelName, callback);
        this.registerCallback(customCallback);
    }

    @Override
    public void registerForwardCallback(String channelName, Predicate<ByteArrayDataInput> callback) {
        Predicate<ByteArrayDataInput> cb = Objects.requireNonNull(callback, "callback");
        ForwardCustomCallback customCallback = new ForwardCustomCallback(channelName, bytes -> cb.test(ByteStreams.newDataInput(bytes)));
        this.registerCallback(customCallback);
    }

    private static interface MessageCallback {
        public String getSubChannel();

        default public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return true;
        }

        public boolean acceptResponse(Player var1, ByteArrayDataInput var2);
    }

    private static interface MessageAgent {
        public String getSubChannel();

        @Nullable
        default public Player getHandle() {
            return null;
        }

        default public void appendPayload(ByteArrayDataOutput out) {
        }
    }

    private static final class ConnectAgent
    implements MessageAgent {
        private static final String CHANNEL = "Connect";
        private final Player player;
        private final String serverName;

        private ConnectAgent(Player player, String serverName) {
            this.player = Objects.requireNonNull(player, "player");
            this.serverName = Objects.requireNonNull(serverName, "serverName");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }
    }

    private static final class ConnectOtherAgent
    implements MessageAgent {
        private static final String CHANNEL = "ConnectOther";
        private final String playerName;
        private final String serverName;

        private ConnectOtherAgent(String playerName, String serverName) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.serverName = Objects.requireNonNull(serverName, "serverName");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.serverName);
        }
    }

    private static final class IPAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "IP";
        private final Player player;
        private final Promise<Map.Entry<String, Integer>> callback;

        private IPAgent(Player player, Promise<Map.Entry<String, Integer>> callback) {
            this.player = Objects.requireNonNull(player, "player");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return receiver.getUniqueId().equals(this.player.getUniqueId());
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            String ip = in.readUTF();
            int port = in.readInt();
            this.callback.supply(Maps.immutableEntry(ip, port));
            return true;
        }
    }

    private static final class PlayerCountAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "PlayerCount";
        private final String serverName;
        private final Promise<Integer> callback;

        private PlayerCountAgent(String serverName, Promise<Integer> callback) {
            this.serverName = Objects.requireNonNull(serverName, "serverName");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            int count = in.readInt();
            this.callback.supply(count);
            return true;
        }
    }

    private static final class PlayerListAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "PlayerList";
        private final String serverName;
        private final Promise<List<String>> callback;

        private PlayerListAgent(String serverName, Promise<List<String>> callback) {
            this.serverName = Objects.requireNonNull(serverName, "serverName");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String csv = in.readUTF();
            if (csv.isEmpty()) {
                this.callback.supply(ImmutableList.of());
                return true;
            }
            this.callback.supply(ImmutableList.copyOf(Splitter.on(", ").splitToList(csv)));
            return true;
        }
    }

    private static final class GetServersAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "GetServers";
        private final Promise<List<String>> callback;

        private GetServersAgent(Promise<List<String>> callback) {
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            String csv = in.readUTF();
            if (csv.isEmpty()) {
                this.callback.supply(ImmutableList.of());
                return true;
            }
            this.callback.supply(ImmutableList.copyOf(Splitter.on(", ").splitToList(csv)));
            return true;
        }
    }

    private static final class PlayerMessageAgent
    implements MessageAgent {
        private static final String CHANNEL = "Message";
        private final String playerName;
        private final String message;

        private PlayerMessageAgent(String playerName, String message) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.message = Objects.requireNonNull(message, "message");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.message);
        }
    }

    private static final class GetServerAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "GetServer";
        private final Promise<String> callback;

        private GetServerAgent(Promise<String> callback) {
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            this.callback.supply(in.readUTF());
            return true;
        }
    }

    private static final class UUIDAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "UUID";
        private final Player player;
        private final Promise<UUID> callback;

        private UUIDAgent(Player player, Promise<UUID> callback) {
            this.player = Objects.requireNonNull(player, "player");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return receiver.getUniqueId().equals(this.player.getUniqueId());
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            String uuid = in.readUTF();
            this.callback.supply(UUID.fromString(uuid));
            return true;
        }
    }

    private static final class UUIDOtherAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "UUIDOther";
        private final String playerName;
        private final Promise<UUID> callback;

        private UUIDOtherAgent(String playerName, Promise<UUID> callback) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.playerName);
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String uuid = in.readUTF();
            this.callback.supply(UUID.fromString(uuid));
            return true;
        }
    }

    private static final class ServerIPAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "ServerIP";
        private final String serverName;
        private final Promise<Map.Entry<String, Integer>> callback;

        private ServerIPAgent(String serverName, Promise<Map.Entry<String, Integer>> callback) {
            this.serverName = Objects.requireNonNull(serverName, "serverName");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean testResponse(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String ip = in.readUTF();
            int port = in.readInt();
            this.callback.supply(Maps.immutableEntry(ip, port));
            return true;
        }
    }

    private static final class KickPlayerAgent
    implements MessageAgent {
        private static final String CHANNEL = "KickPlayer";
        private final String playerName;
        private final String reason;

        private KickPlayerAgent(String playerName, String reason) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.reason = Objects.requireNonNull(reason, "reason");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.reason);
        }
    }

    private static final class ForwardAgent
    implements MessageAgent {
        private static final String CHANNEL = "Forward";
        private final String serverName;
        private final String channelName;
        private final byte[] data;

        private ForwardAgent(String serverName, String channelName, byte[] data) {
            this.serverName = Objects.requireNonNull(serverName, "serverName");
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.data = data;
        }

        private ForwardAgent(String serverName, String channelName, ByteArrayDataOutput data) {
            this.serverName = Objects.requireNonNull(serverName, "serverName");
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.data = Objects.requireNonNull(data, "data").toByteArray();
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
            out.writeUTF(this.channelName);
            out.writeShort(this.data.length);
            out.write(this.data);
        }
    }

    private static final class ForwardToPlayerAgent
    implements MessageAgent {
        private static final String CHANNEL = "ForwardToPlayer";
        private final String playerName;
        private final String channelName;
        private final byte[] data;

        private ForwardToPlayerAgent(String playerName, String channelName, byte[] data) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.data = data;
        }

        private ForwardToPlayerAgent(String playerName, String channelName, ByteArrayDataOutput data) {
            this.playerName = Objects.requireNonNull(playerName, "playerName");
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.data = Objects.requireNonNull(data, "data").toByteArray();
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.channelName);
            out.writeShort(this.data.length);
            out.write(this.data);
        }
    }

    private static final class ForwardCustomCallback
    implements MessageCallback {
        private final String subChannel;
        private final Predicate<byte[]> callback;

        private ForwardCustomCallback(String subChannel, Predicate<byte[]> callback) {
            this.subChannel = Objects.requireNonNull(subChannel, "subChannel");
            this.callback = Objects.requireNonNull(callback, "callback");
        }

        @Override
        public String getSubChannel() {
            return this.subChannel;
        }

        @Override
        public boolean acceptResponse(Player receiver, ByteArrayDataInput in) {
            short len = in.readShort();
            byte[] data = new byte[len];
            in.readFully(data);
            return this.callback.test(data);
        }
    }
}

