/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.metadata;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Players;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.metadata.MetadataKey;
import io.lumine.xikage.mythicmobs.utils.metadata.MetadataMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;

public final class Metadata {
    private static LoadingCache<UUID, MetadataMap> players = null;
    private static LoadingCache<UUID, MetadataMap> entities = null;
    private static LoadingCache<UUID, MetadataMap> worlds = null;

    private static synchronized void setup() {
        if (players != null) {
            return;
        }
        players = Metadata.makeCache();
        entities = Metadata.makeCache();
        worlds = Metadata.makeCache();
        Events.subscribe(PlayerQuitEvent.class, EventPriority.MONITOR).handler(e -> {
            MetadataMap map = (MetadataMap)players.asMap().remove(e.getPlayer().getUniqueId());
            if (map != null) {
                map.clear();
            }
        });
        Schedulers.async().runRepeating(() -> {
            players.asMap().values().removeIf(MetadataMap::isEmpty);
            entities.asMap().values().removeIf(MetadataMap::isEmpty);
            worlds.asMap().values().removeIf(MetadataMap::isEmpty);
        }, 1200L + (long)ThreadLocalRandom.current().nextInt(20), 1200L);
    }

    private static <T> LoadingCache<T, MetadataMap> makeCache() {
        return CacheBuilder.newBuilder().build(new CacheLoader<T, MetadataMap>(){

            @Override
            public MetadataMap load(T uuid) {
                return MetadataMap.create();
            }
        });
    }

    public static MetadataMap provide(Object obj) {
        if (obj instanceof Player) {
            return Metadata.provideForPlayer((Player)obj);
        }
        if (obj instanceof UUID) {
            return Metadata.provideForPlayer((UUID)obj);
        }
        if (obj instanceof Entity) {
            return Metadata.provideForEntity((Entity)obj);
        }
        if (obj instanceof World) {
            return Metadata.provideForWorld((World)obj);
        }
        throw new IllegalArgumentException("Unknown object type: " + obj.getClass());
    }

    public static MetadataMap provideForPlayer(Player player) {
        Metadata.setup();
        return players.getUnchecked(player.getUniqueId());
    }

    public static MetadataMap provideForPlayer(UUID uuid) {
        Metadata.setup();
        return players.getUnchecked(uuid);
    }

    public static <T> Map<Player, T> lookupPlayersWithKey(MetadataKey<T> key) {
        Preconditions.checkNotNull("key", key);
        Metadata.setup();
        ImmutableMap.Builder ret = ImmutableMap.builder();
        players.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
            Player player = Players.getNullable(uuid);
            if (player != null) {
                ret.put(player, t);
            }
        }));
        return ret.build();
    }

    public static MetadataMap provideForEntity(Entity entity) {
        Metadata.setup();
        if (entity instanceof Player) {
            return Metadata.provideForPlayer((Player)entity);
        }
        return entities.getUnchecked(entity.getUniqueId());
    }

    public static <T> Map<Entity, T> lookupEntitiesWithKey(MetadataKey<T> key) {
        Preconditions.checkNotNull("key", key);
        Metadata.setup();
        ImmutableMap.Builder ret = ImmutableMap.builder();
        entities.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity != null) {
                ret.put(entity, t);
            }
        }));
        return ret.build();
    }

    public static MetadataMap provideForWorld(World world) {
        Metadata.setup();
        return worlds.getUnchecked(world.getUID());
    }

    public static <T> Map<World, T> lookupWorldsWithKey(MetadataKey<T> key) {
        Preconditions.checkNotNull("key", key);
        Metadata.setup();
        ImmutableMap.Builder ret = ImmutableMap.builder();
        worlds.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
            World world = Bukkit.getWorld((UUID)uuid);
            if (world != null) {
                ret.put(world, t);
            }
        }));
        return ret.build();
    }

    private Metadata() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

