/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.menu;

import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.utils.menu.Icon;
import io.lumine.xikage.mythicmobs.utils.menu.MenuData;
import io.lumine.xikage.mythicmobs.utils.menu.MenuHelper;
import io.lumine.xikage.mythicmobs.utils.menu.MonitoredState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class Menu<T> {
    private final Function<T, String> titleFunc;
    private final Function<T, MonitoredState> monitorFunc;
    private final Map<Integer, Icon<? super T>> icons;
    private int size = -1;
    private List<Integer> sortSlots = null;
    private int minSort;
    private int maxSort;
    private List<Integer> blinkSlots = null;
    private final List<Integer> dataSlots;

    protected Menu(Function<T, String> titleFunc, Function<T, MonitoredState> monitorFunc, Map<Integer, Icon<? super T>> icons, List<Integer> dataSlots, List<Integer> blinking) {
        this.titleFunc = titleFunc;
        this.monitorFunc = monitorFunc;
        this.icons = icons;
        this.dataSlots = dataSlots;
        if (blinking != null && blinking.size() > 0) {
            this.blinkSlots = blinking;
        }
    }

    protected Menu(Function<T, String> titleFunc, Function<T, MonitoredState> monitorFunc, Map<Integer, Icon<? super T>> icons, List<Integer> dataSlots, List<Integer> sortable, List<Integer> blinking) {
        this(titleFunc, monitorFunc, icons, dataSlots, blinking);
        this.sortSlots = sortable;
        Optional maybeMinSort = sortable.stream().min(Comparator.naturalOrder());
        Optional maybeMaxSort = sortable.stream().max(Comparator.naturalOrder());
        if (!maybeMinSort.isPresent()) {
            this.sortSlots = null;
            return;
        }
        this.minSort = (Integer)maybeMinSort.get();
        if (!maybeMaxSort.isPresent()) {
            this.sortSlots = null;
            return;
        }
        this.maxSort = (Integer)maybeMaxSort.get();
    }

    public Menu<T> setSize(int size) {
        this.size = size;
        return this;
    }

    protected Map<Integer, Icon<? super T>> getIcons() {
        return this.icons;
    }

    protected Optional<Icon<? super T>> getIcon(int slot) {
        return Optional.ofNullable(this.icons.get(slot));
    }

    protected Optional<List<Integer>> getBlinkingSlots() {
        return Optional.ofNullable(this.blinkSlots);
    }

    protected Optional<MonitoredState> getMonitoredState(T state) {
        if (this.monitorFunc == null) {
            return Optional.empty();
        }
        return Optional.of(this.monitorFunc.apply(state));
    }

    protected void sort(final T state) {
        int i;
        if (this.sortSlots == null) {
            return;
        }
        ArrayList<Icon<T>> sort = new ArrayList<Icon<T>>();
        for (i = this.minSort; i <= this.maxSort; ++i) {
            if (!this.getIcon(i).isPresent()) continue;
            sort.add(this.getIcon(i).get());
        }
        Collections.sort(sort, new Comparator<Icon<? super T>>(){

            @Override
            public int compare(Icon<? super T> i1, Icon<? super T> i2) {
                int x1 = i1.getAmount(state);
                int x2 = i2.getAmount(state);
                return x2 - x1;
            }
        });
        i = this.minSort;
        for (Icon icon : sort) {
            this.icons.put(i, icon);
            ++i;
        }
    }

    protected int getMinSortedSlot() {
        return this.minSort;
    }

    protected int getMaxSortedSlot() {
        return this.maxSort;
    }

    public void open(Player player, T state) {
        this.open(player, state, Lists.newArrayList());
    }

    public void open(Player player, T state, List<MenuData<T>> data) {
        if (this.icons.isEmpty()) {
            throw new IllegalStateException("Tried to open an empty menu!");
        }
        int max = (Integer)this.icons.keySet().stream().sorted(Comparator.reverseOrder()).findFirst().get();
        int size = this.size;
        if (size < 0) {
            size = (int)Math.ceil((double)(max + 1) / 9.0) * 9;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)this.titleFunc.apply(state));
        this.sort(state);
        this.icons.forEach((slot, icon) -> inventory.setItem(slot.intValue(), icon.build(state, player)));
        if (this.dataSlots.size() > 0) {
            int start;
            int dataPerPage = this.dataSlots.size();
            int end = (start = 0 * dataPerPage) + dataPerPage;
            List<MenuData<T>> displayedData = data.subList(start, end < data.size() ? end : data.size());
            int count = 0;
            for (int slot2 : this.dataSlots) {
                if (count >= displayedData.size()) break;
                inventory.setItem(slot2, displayedData.get(count).getIcon().build(state, player));
                ++count;
            }
        }
        player.openInventory(inventory);
        MenuHelper.registerOpen(player, this, inventory, state, data);
    }

    public void nextPage(Player player) {
        MenuHelper.moveToNextPage(player);
    }

    public void previousPage(Player player) {
        MenuHelper.moveToPreviousPage(player);
    }

    public List<Integer> getDataSlots() {
        return this.dataSlots;
    }
}

