/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.items;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.utils.annotation.NonnullByDefault;
import io.lumine.xikage.mythicmobs.utils.config.LineConfig;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomInt;
import io.lumine.xikage.mythicmobs.utils.text.Text;
import io.lumine.xikage.mythicmobs.utils.uuid.DashedUUIDs;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@NonnullByDefault
public class ItemFactory {
    private static final ItemFlag[] ALL_FLAGS = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_PLACED_ON};
    private final ItemStack itemStack;
    private boolean clone = true;

    public static ItemFactory of(Material material) {
        return new ItemFactory(new ItemStack(material));
    }

    public static ItemFactory of(ItemStack itemStack) {
        return new ItemFactory(itemStack);
    }

    public static ItemFactory of(String line) {
        return ItemFactory.of(LineConfig.of(line));
    }

    public static ItemFactory of(LineConfig lc) {
        String[] split;
        Material material = Material.STONE;
        String mat = lc.getKey();
        if (mat.contains(" ")) {
            mat = mat.split(" ")[0];
        }
        if (mat.startsWith("mythicmobs.")) {
            ItemStack item = MythicMobs.inst().getItemManager().getItemStack(mat.substring(11));
            return ItemFactory.of(item);
        }
        try {
            material = Material.valueOf((String)mat.toUpperCase());
        }
        catch (Exception ex) {
            Log.info("Invalid item material {0} on line {1}", mat, lc.getLine());
        }
        ItemFactory factory = ItemFactory.of(material);
        String display = lc.getString(new String[]{"name", "display", "n", "d"}, null, new String[0]);
        int data = lc.getInteger(new String[]{"data"}, 0);
        int model = lc.getInteger(new String[]{"model"}, 0);
        int amount = lc.getInteger(new String[]{"amount", "a"}, 1);
        String lore = lc.getString(new String[]{"lore", "l"}, null, new String[0]);
        String enchantments = lc.getString(new String[]{"enchantments", "enchants", "ench", "e"}, null, new String[0]);
        String potionEffects = lc.getString(new String[]{"potioneffects", "peffects", "potion", "pe"}, null, new String[0]);
        String color = lc.getString(new String[]{"color", "c", "potioncolor", "pcolor", "pc"}, null, new String[0]);
        String skullOwner = lc.getString(new String[]{"skullowner"}, null, new String[0]);
        String skullTexture = lc.getString(new String[]{"skulltexture"}, null, new String[0]);
        if (display != null) {
            if (display.startsWith("\"")) {
                display = display.substring(1, display.length() - 1);
            }
            display = LineConfig.parseSpecialChars(display);
            factory.name(display);
        }
        if (data > 0) {
            factory.data((byte)data);
        }
        if (model > 0) {
            factory.model(model);
        }
        if (amount != 1) {
            factory.amount(amount);
        }
        if (lore != null) {
            try {
                ArrayList<String> loreList = new ArrayList<String>();
                String[] stringArray = lore.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s2 = stringArray[i];
                    String lores = s2.substring(1, s2.length() - 1);
                    lores = LineConfig.parseSpecialChars(lores);
                    loreList.add(lores);
                }
                factory.lore(loreList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (enchantments != null) {
            try {
                for (String s3 : enchantments.split(",")) {
                    Log.info("brrrrrrrrrr {0}", s3);
                    try {
                        split = s3.split(":");
                        String enchantName = split[0];
                        Enchantment ench = enchantName.equalsIgnoreCase("random") ? Enchantment.values()[Numbers.randomInt(Enchantment.values().length)] : Enchantment.getByName((String)enchantName);
                        int level = new RandomInt(split[1]).get();
                        factory.enchant(ench, level);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured enchantment");
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (potionEffects != null) {
            try {
                for (String s4 : potionEffects.split(",")) {
                    try {
                        split = s4.split(":");
                        PotionEffectType type = PotionEffectType.getByName((String)split[0].toUpperCase());
                        int duration = Integer.parseInt(split[1]);
                        int amplifier = 0;
                        if (split.length > 2) {
                            amplifier = Integer.parseInt(split[2]);
                        }
                        factory.potionEffect(type, duration, amplifier);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured potion effect " + s4);
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (color != null) {
            factory.color(color);
        }
        if (skullOwner != null) {
            factory.skullOwner(skullOwner);
        }
        if (skullTexture != null) {
            factory.skullTexture(skullTexture);
        }
        return factory;
    }

    protected ItemFactory() {
        this.itemStack = new ItemStack(Material.STONE);
    }

    protected ItemFactory(ItemStack itemStack) {
        this.itemStack = Objects.requireNonNull(itemStack, "itemStack");
    }

    public ItemFactory transform(Consumer<ItemStack> is) {
        is.accept(this.itemStack);
        return this;
    }

    public ItemFactory transformMeta(Consumer<ItemMeta> meta) {
        ItemMeta m3 = this.itemStack.getItemMeta();
        if (m3 != null) {
            meta.accept(m3);
            this.itemStack.setItemMeta(m3);
        }
        return this;
    }

    public ItemFactory name(String name) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> meta.setDisplayNameComponent(Text.colorizeBungee(name)));
        }
        return this.transformMeta(meta -> meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name)));
    }

    public ItemFactory type(Material material) {
        return this.transform(itemStack -> itemStack.setType(material));
    }

    public ItemFactory lore(String line) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<BaseComponent[]> lore = meta.getLore() == null ? new ArrayList() : meta.getLoreComponents();
                lore.add(Text.colorizeBungee(line));
                meta.setLoreComponents(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add(Text.colorize(line));
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(String ... lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<BaseComponent[]> lore = meta.getLore() == null ? new ArrayList() : meta.getLoreComponents();
                for (String line : lines) {
                    lore.add(Text.colorizeBungee(line));
                }
                meta.setLoreComponents(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(Iterable<String> lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<BaseComponent[]> lore = meta.getLore() == null ? new ArrayList() : meta.getLoreComponents();
                for (String line : lines) {
                    lore.add(Text.colorizeBungee(line));
                }
                meta.setLoreComponents(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(Function<List<String>, Iterable<String>> linesFunc) {
        Iterable<String> lines = linesFunc.apply(Lists.newArrayList());
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<BaseComponent[]> lore = meta.getLore() == null ? new ArrayList() : meta.getLoreComponents();
                for (String line : lines) {
                    lore.add(Text.colorizeBungee(line));
                }
                meta.setLoreComponents(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory clearLore() {
        return this.transformMeta(meta -> meta.setLore(new ArrayList()));
    }

    public ItemFactory durability(int durability) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_15)) {
            return this.transform(itemStack -> itemStack.setDurability((short)durability));
        }
        return this.transformMeta(meta -> {
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(durability);
            }
        });
    }

    public ItemFactory data(int data) {
        return this.durability(data);
    }

    public ItemFactory amount(int amount) {
        return this.transform(itemStack -> itemStack.setAmount(amount));
    }

    public ItemFactory model(int model) {
        return this.transformMeta(meta -> meta.setCustomModelData(Integer.valueOf(model)));
    }

    public ItemFactory enchant(Enchantment enchantment, int level) {
        return this.transform(itemStack -> {
            if (itemStack.getType() != Material.ENCHANTED_BOOK) {
                itemStack.addUnsafeEnchantment(enchantment, level);
            } else {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)itemStack.getItemMeta();
                esm.addStoredEnchant(enchantment, level, true);
                itemStack.setItemMeta((ItemMeta)esm);
            }
        });
    }

    public ItemFactory enchant(Enchantment enchantment) {
        return this.enchant(enchantment, 1);
    }

    public ItemFactory clearEnchantments() {
        return this.transform(itemStack -> itemStack.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)itemStack).removeEnchantment(arg_0)));
    }

    public ItemFactory potionEffect(PotionEffectType type, int duration, int amplifier) {
        return this.transformMeta(meta -> {
            if (meta instanceof PotionMeta) {
                PotionMeta pMeta = (PotionMeta)meta;
                PotionEffect effect = new PotionEffect(type, duration, amplifier);
                pMeta.addCustomEffect(effect, true);
            }
        });
    }

    public ItemFactory potionEffect(PotionEffectType type, int duration) {
        return this.potionEffect(type, duration, 0);
    }

    public ItemFactory clearPotionEffects() {
        return this.transformMeta(meta -> {
            if (meta instanceof PotionMeta) {
                PotionMeta pMeta = (PotionMeta)meta;
                pMeta.clearCustomEffects();
            }
        });
    }

    public ItemFactory color(String colorCode) {
        return this.transformMeta(meta -> {
            PotionMeta pMeta;
            int b;
            int g2;
            int r;
            if (colorCode.startsWith("#")) {
                Color color = Color.decode(colorCode);
                r = color.getRed();
                g2 = color.getGreen();
                b = color.getBlue();
            } else if (colorCode.contains(",")) {
                String[] rgb = colorCode.split(",");
                r = Integer.parseInt(rgb[0]);
                g2 = Integer.parseInt(rgb[1]);
                b = Integer.parseInt(rgb[2]);
            } else {
                DyeColor dColor = DyeColor.valueOf((String)colorCode.toUpperCase());
                org.bukkit.Color color = dColor.getFireworkColor();
                r = color.getRed();
                g2 = color.getGreen();
                b = color.getBlue();
            }
            if (meta instanceof PotionMeta) {
                pMeta = (PotionMeta)meta;
                pMeta.setColor(org.bukkit.Color.fromRGB((int)r, (int)g2, (int)b));
            } else if (meta instanceof LeatherArmorMeta) {
                pMeta = (PotionMeta)meta;
                pMeta.setColor(org.bukkit.Color.fromRGB((int)r, (int)g2, (int)b));
            }
        });
    }

    public ItemFactory flag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.addItemFlags(flags));
    }

    public ItemFactory unflag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.removeItemFlags(flags));
    }

    public ItemFactory hideAttributes() {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            this.flag(ItemFlag.HIDE_DYE);
        }
        return this.flag(ALL_FLAGS);
    }

    public ItemFactory showAttributes() {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            this.unflag(ItemFlag.HIDE_DYE);
        }
        return this.unflag(ALL_FLAGS);
    }

    public ItemFactory color(org.bukkit.Color color) {
        return this.transform(itemStack -> {
            Material type = itemStack.getType();
            if (type == Material.LEATHER_BOOTS || type == Material.LEATHER_CHESTPLATE || type == Material.LEATHER_HELMET || type == Material.LEATHER_LEGGINGS) {
                LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
                meta.setColor(color);
                itemStack.setItemMeta((ItemMeta)meta);
            }
        });
    }

    public ItemFactory breakable(boolean flag) {
        return this.transformMeta(meta -> meta.setUnbreakable(!flag));
    }

    public ItemFactory skullOwner(String owner) {
        return this.transformMeta(meta -> {
            if (!(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta im = (SkullMeta)meta;
            im.setOwner(owner);
        });
    }

    public ItemFactory skullTexture(String texture) {
        return this.transformMeta(meta -> {
            if (!(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta im = (SkullMeta)meta;
            UUID skinUUID = im.getDisplayName() != null ? DashedUUIDs.getUUIDFromString(im.getDisplayName()) : UUID.randomUUID();
            GameProfile profile = new GameProfile(skinUUID, null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            Field profileField = null;
            try {
                profileField = im.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(im, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        });
    }

    public ItemFactory apply(Consumer<ItemFactory> consumer) {
        consumer.accept(this);
        return this;
    }

    public ItemStack build() {
        return this.itemStack.clone();
    }
}

