/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.holograms;

import com.google.common.base.Preconditions;
import io.lumine.xikage.mythicmobs.utils.gson.JsonArray;
import io.lumine.xikage.mythicmobs.utils.gson.JsonElement;
import io.lumine.xikage.mythicmobs.utils.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.holograms.Hologram;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public interface HologramFactory {
    @Nonnull
    public Hologram newHologram(@Nonnull Position var1, @Nonnull List<String> var2);

    @Nonnull
    default public Hologram deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("position"));
        Preconditions.checkArgument(object.has("lines"));
        Position position = Position.deserialize(object.get("position"));
        JsonArray lineArray = object.get("lines").getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (JsonElement e : lineArray) {
            lines.add(e.getAsString());
        }
        return this.newHologram(position, lines);
    }
}

