/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.gson.adapters;

import io.lumine.xikage.mythicmobs.utils.gson.Gson;
import io.lumine.xikage.mythicmobs.utils.gson.GsonProvider;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonElement;
import io.lumine.xikage.mythicmobs.utils.gson.TypeAdapter;
import io.lumine.xikage.mythicmobs.utils.gson.TypeAdapterFactory;
import io.lumine.xikage.mythicmobs.utils.gson.reflect.TypeToken;
import io.lumine.xikage.mythicmobs.utils.gson.stream.JsonReader;
import io.lumine.xikage.mythicmobs.utils.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;

public final class GsonSerializableAdapterFactory
implements TypeAdapterFactory {
    public static final GsonSerializableAdapterFactory INSTANCE = new GsonSerializableAdapterFactory();

    private GsonSerializableAdapterFactory() {
    }

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        Class<T> clazz = type.getRawType();
        final Method deserializeMethod = GsonSerializable.getDeserializeMethod(clazz);
        if (deserializeMethod == null) {
            return null;
        }
        TypeAdapter<GsonSerializable> typeAdapter = new TypeAdapter<GsonSerializable>(){

            @Override
            public void write(JsonWriter out, GsonSerializable value) {
                if (value == null) {
                    gson.toJson(null, out);
                    return;
                }
                gson.toJson(value.serialize(), out);
            }

            @Override
            public GsonSerializable read(JsonReader in) throws IOException {
                JsonElement element = GsonProvider.parser().parse(in);
                if (element.isJsonNull()) {
                    return null;
                }
                try {
                    return (GsonSerializable)deserializeMethod.invoke(null, element);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
        return typeAdapter;
    }
}

