/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.gson;

import io.lumine.xikage.mythicmobs.utils.gson.Gson;
import io.lumine.xikage.mythicmobs.utils.gson.GsonBuilder;
import io.lumine.xikage.mythicmobs.utils.gson.JsonElement;
import io.lumine.xikage.mythicmobs.utils.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.gson.JsonParser;
import io.lumine.xikage.mythicmobs.utils.gson.adapters.BukkitSerializableAdapterFactory;
import io.lumine.xikage.mythicmobs.utils.gson.adapters.FuckyTypeAdapterFactory;
import io.lumine.xikage.mythicmobs.utils.gson.adapters.GsonSerializableAdapterFactory;
import java.io.Reader;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class GsonProvider {
    private static final GsonBuilder STANDARD_GSON_BUILDER = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").registerTypeAdapterFactory(GsonSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory(BukkitSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory(FuckyTypeAdapterFactory.INSTANCE).serializeNulls().disableHtmlEscaping();
    private static final GsonBuilder PRETTY_PRINT_GSON_BUILDER = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").registerTypeAdapterFactory(GsonSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory(BukkitSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory(FuckyTypeAdapterFactory.INSTANCE).serializeNulls().disableHtmlEscaping().setPrettyPrinting();
    private static Gson STANDARD_GSON = STANDARD_GSON_BUILDER.create();
    private static Gson PRETTY_PRINT_GSON = PRETTY_PRINT_GSON_BUILDER.create();
    private static final JsonParser PARSER = new JsonParser();

    @Nonnull
    public static Gson standard() {
        return STANDARD_GSON;
    }

    @Nonnull
    public static Gson prettyPrinting() {
        return PRETTY_PRINT_GSON;
    }

    public static void update(Consumer<GsonBuilder> func) {
        func.accept(STANDARD_GSON_BUILDER);
        func.accept(PRETTY_PRINT_GSON_BUILDER);
        STANDARD_GSON = STANDARD_GSON_BUILDER.create();
        PRETTY_PRINT_GSON = PRETTY_PRINT_GSON_BUILDER.create();
    }

    @Nonnull
    public static JsonParser parser() {
        return PARSER;
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull Reader reader) {
        return PARSER.parse(reader).getAsJsonObject();
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull String s2) {
        return PARSER.parse(s2).getAsJsonObject();
    }

    public static void writeObject(@Nonnull Appendable writer, @Nonnull JsonObject object) {
        GsonProvider.standard().toJson((JsonElement)object, writer);
    }

    public static void writeObjectPretty(@Nonnull Appendable writer, @Nonnull JsonObject object) {
        GsonProvider.prettyPrinting().toJson((JsonElement)object, writer);
    }

    public static void writeElement(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.standard().toJson(element, writer);
    }

    public static void writeElementPretty(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.prettyPrinting().toJson(element, writer);
    }

    @Nonnull
    public static String toString(@Nonnull JsonElement element) {
        return Objects.requireNonNull(GsonProvider.standard().toJson(element));
    }

    @Nonnull
    public static String toStringPretty(@Nonnull JsonElement element) {
        return Objects.requireNonNull(GsonProvider.prettyPrinting().toJson(element));
    }

    private GsonProvider() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    @Nonnull
    @Deprecated
    public static Gson get() {
        return GsonProvider.standard();
    }

    @Nonnull
    @Deprecated
    public static Gson getPrettyPrinting() {
        return GsonProvider.prettyPrinting();
    }
}

