/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyHolder;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyScope;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class PropertyType<T> {
    protected final LuminePlugin plugin;
    protected ConfigurationSection config;
    protected final Map<String, ConfigurationSection> holderSections = new HashMap<String, ConfigurationSection>();
    protected String file = null;
    protected boolean fileAbsolute;
    protected final String node;

    public PropertyType(LuminePlugin plugin, Object scope, String node) {
        plugin.registerProperty(this);
        this.plugin = plugin;
        this.node = node;
        this.setScope(scope);
    }

    public void reload() {
        this.load();
    }

    public void setScope(Object scope) {
        if (scope == null) {
            this.file = null;
            this.fileAbsolute = false;
        } else if (scope instanceof PropertyScope) {
            this.file = ((PropertyScope)scope).get();
            this.fileAbsolute = false;
        } else if (scope instanceof File) {
            this.file = ((File)scope).getAbsolutePath();
            this.fileAbsolute = true;
        } else if (scope instanceof String) {
            this.file = (String)scope;
            this.fileAbsolute = false;
        } else {
            this.file = scope.toString();
            this.fileAbsolute = false;
        }
        this.load();
    }

    private void load() {
        if (this.file == null || this.file.isEmpty()) {
            return;
        }
        this.config = this.plugin.getPropertyConfig(this.file, this.fileAbsolute);
        this.holderSections.clear();
    }

    public T get() {
        return this.compute(this.config, this.node);
    }

    public T get(PropertyHolder holder) {
        return this.get(holder.getPropertyNode());
    }

    public T get(String holder) {
        if (this.file == null || this.file.isEmpty()) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        this.holderSections.computeIfAbsent(holder, _holder -> this.config.getConfigurationSection(holder));
        return this.compute(this.holderSections.get(holder), this.node);
    }

    public T get(ConfigurationSection section) {
        if (this.file == null || this.file.isEmpty()) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        return this.compute(section, this.node);
    }

    public T fget(Object scope) {
        this.setScope(scope);
        return this.compute(this.config, this.node);
    }

    public T fget(Object scope, PropertyHolder holder) {
        this.setScope(scope);
        return this.get(holder.getPropertyNode());
    }

    public T fget(Object scope, String holder) {
        this.setScope(scope);
        if (this.file == null) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        this.holderSections.computeIfAbsent(holder, _holder -> this.config.getConfigurationSection(holder));
        return this.compute(this.holderSections.get(holder), this.node);
    }

    public T fget(Object scope, ConfigurationSection section) {
        this.setScope(scope);
        if (this.file == null) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        return this.compute(section, this.node);
    }

    protected abstract T compute(ConfigurationSection var1, String var2);

    public void set(PropertyHolder holder, T value) {
        this.set(holder.getPropertyNode(), value);
    }

    public void set(T value) {
        this.set((String)null, value);
    }

    public void set(String holder, T value) {
        if (this.config == null) {
            Log.info("HOLDER NULL");
            return;
        }
        if (holder != null) {
            this.config.set(holder + "." + this.node, value);
        } else {
            this.config.set(this.node, value);
        }
        try {
            Log.info("Setting file " + this.config + " TO FILE " + this.file);
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    public LuminePlugin getPlugin() {
        return this.plugin;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isFileAbsolute() {
        return this.fileAbsolute;
    }

    public String getNode() {
        return this.node;
    }
}

