/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.gson;

import io.lumine.xikage.mythicmobs.utils.adventure.text.format.TextColor;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.TextDecoration;
import io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.gson.TextColorSerializer;
import io.lumine.xikage.mythicmobs.utils.gson.JsonParseException;
import io.lumine.xikage.mythicmobs.utils.gson.JsonSyntaxException;
import io.lumine.xikage.mythicmobs.utils.gson.TypeAdapter;
import io.lumine.xikage.mythicmobs.utils.gson.stream.JsonReader;
import io.lumine.xikage.mythicmobs.utils.gson.stream.JsonWriter;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TextColorWrapper {
    final @Nullable TextColor color;
    final @Nullable TextDecoration decoration;
    final boolean reset;

    TextColorWrapper(@Nullable TextColor color, @Nullable TextDecoration decoration, boolean reset) {
        this.color = color;
        this.decoration = decoration;
        this.reset = reset;
    }

    static class Serializer
    extends TypeAdapter<TextColorWrapper> {
        Serializer() {
        }

        @Override
        public void write(JsonWriter out, TextColorWrapper value) {
            throw new JsonSyntaxException("Cannot write TextColorWrapper instances");
        }

        @Override
        public TextColorWrapper read(JsonReader in) throws IOException {
            boolean reset;
            String input = in.nextString();
            TextColor color = TextColorSerializer.fromString(input);
            TextDecoration decoration = TextDecoration.NAMES.value(input);
            boolean bl = reset = decoration == null && input.equals("reset");
            if (color == null && decoration == null && !reset) {
                throw new JsonParseException("Don't know how to parse " + input + " at " + in.getPath());
            }
            return new TextColorWrapper(color, decoration, reset);
        }
    }
}

