/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.facet;

import io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Facet;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.translation.GlobalTranslator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class FacetBossBarListener<V>
implements Facet.BossBar<V> {
    private final Facet.BossBar<V> facet;
    private final Supplier<Locale> locale;

    FacetBossBarListener(@NotNull Facet.BossBar<V> facet, @NotNull Supplier<Locale> locale) {
        this.facet = facet;
        this.locale = locale;
    }

    @Override
    public void bossBarInitialized(@NotNull BossBar bar) {
        this.facet.bossBarInitialized(bar);
        this.bossBarNameChanged(bar, bar.name(), bar.name());
    }

    @Override
    public void bossBarNameChanged(@NotNull BossBar bar, @NotNull Component oldName, @NotNull Component newName) {
        this.facet.bossBarNameChanged(bar, oldName, GlobalTranslator.render(newName, this.locale.get()));
    }

    @Override
    public void bossBarProgressChanged(@NotNull BossBar bar, float oldPercent, float newPercent) {
        this.facet.bossBarProgressChanged(bar, oldPercent, newPercent);
    }

    @Override
    public void bossBarColorChanged(@NotNull BossBar bar, @NotNull BossBar.Color oldColor, @NotNull BossBar.Color newColor) {
        this.facet.bossBarColorChanged(bar, oldColor, newColor);
    }

    @Override
    public void bossBarOverlayChanged(@NotNull BossBar bar, @NotNull BossBar.Overlay oldOverlay, @NotNull BossBar.Overlay newOverlay) {
        this.facet.bossBarOverlayChanged(bar, oldOverlay, newOverlay);
    }

    @Override
    public void bossBarFlagsChanged(@NotNull BossBar bar, @NotNull Set<BossBar.Flag> flagsAdded, @NotNull Set<BossBar.Flag> flagsRemoved) {
        this.facet.bossBarFlagsChanged(bar, flagsAdded, flagsRemoved);
    }

    @Override
    public void addViewer(@NotNull V viewer) {
        this.facet.addViewer(viewer);
    }

    @Override
    public void removeViewer(@NotNull V viewer) {
        this.facet.removeViewer(viewer);
    }

    @Override
    public boolean isEmpty() {
        return this.facet.isEmpty();
    }

    @Override
    public void close() {
        this.facet.close();
    }
}

