/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.facet;

import io.lumine.xikage.mythicmobs.utils.adventure.audience.Audience;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.ForwardingAudience;
import io.lumine.xikage.mythicmobs.utils.adventure.key.Key;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.AudienceProvider;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.FacetAudience;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetAudienceProvider<V, A extends FacetAudience<V>>
implements AudienceProvider,
ForwardingAudience {
    private final Audience console;
    private final Audience player;
    private final Map<V, A> viewers = new ConcurrentHashMap<V, A>();
    private final Map<UUID, A> players = new ConcurrentHashMap<UUID, A>();
    private final Set<A> consoles = new CopyOnWriteArraySet<A>();
    private final A empty;
    private volatile boolean closed = false;

    public FacetAudienceProvider() {
        this.console = Audience.audience(this.consoles);
        this.player = Audience.audience(this.players.values());
        this.empty = this.createAudience(Collections.emptyList());
    }

    public void addViewer(@NotNull V viewer) {
        if (this.closed) {
            return;
        }
        FacetAudience audience = this.viewers.computeIfAbsent((FacetAudience)Objects.requireNonNull(viewer, "viewer"), (Function<FacetAudience, A>)((Function<Object, FacetAudience>)v -> this.createAudience(Collections.singletonList(v))));
        UUID playerId = this.hasId(viewer);
        if (playerId != null) {
            this.players.putIfAbsent(playerId, audience);
        } else if (this.isConsole(viewer)) {
            this.consoles.add(audience);
        }
    }

    public void removeViewer(@NotNull V viewer) {
        FacetAudience audience = (FacetAudience)this.viewers.remove(viewer);
        if (audience == null) {
            return;
        }
        UUID playerId = this.hasId(viewer);
        if (playerId != null) {
            this.players.remove(playerId);
        } else if (this.isConsole(viewer)) {
            this.consoles.remove(audience);
        }
        audience.close();
    }

    public void changeViewer(@NotNull V viewer, @NotNull Locale locale) {
        FacetAudience audience = (FacetAudience)this.viewers.get(viewer);
        if (audience != null) {
            audience.changeLocale(locale);
        }
    }

    @Nullable
    protected abstract UUID hasId(@NotNull V var1);

    protected abstract boolean isConsole(@NotNull V var1);

    protected abstract boolean hasPermission(@NotNull V var1, @NotNull String var2);

    protected abstract boolean isInWorld(@NotNull V var1, @NotNull Key var2);

    protected abstract boolean isOnServer(@NotNull V var1, @NotNull String var2);

    @NotNull
    protected abstract A createAudience(@NotNull Collection<V> var1);

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.viewers.values();
    }

    @Override
    @NotNull
    public Audience all() {
        return this;
    }

    @Override
    @NotNull
    public Audience console() {
        return this.console;
    }

    @Override
    @NotNull
    public Audience players() {
        return this.player;
    }

    @Override
    @NotNull
    public Audience player(@NotNull UUID playerId) {
        return (Audience)this.players.getOrDefault(playerId, this.empty);
    }

    @NotNull
    public Audience filter(@NotNull Predicate<V> predicate) {
        return Audience.audience(FacetAudienceProvider.filter(this.viewers.entrySet(), entry -> predicate.test(entry.getKey()), Map.Entry::getValue));
    }

    @Override
    @NotNull
    public Audience permission(@NotNull String permission) {
        return this.filter(viewer -> this.hasPermission(viewer, permission));
    }

    @Override
    @NotNull
    public Audience world(@NotNull Key world) {
        return this.filter(viewer -> this.isInWorld(viewer, world));
    }

    @Override
    @NotNull
    public Audience server(@NotNull String serverName) {
        return this.filter(viewer -> this.isOnServer(viewer, serverName));
    }

    @Override
    public void close() {
        this.closed = true;
        for (V viewer : this.viewers.keySet()) {
            this.removeViewer(viewer);
        }
    }

    @NotNull
    private static <T, V> Iterable<V> filter(final @NotNull Iterable<T> input, final @NotNull Predicate<T> filter, final @NotNull Function<T, V> transformer) {
        return new Iterable<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<T> parent;
                    private V next;
                    {
                        this.parent = input.iterator();
                        this.populate();
                    }

                    private void populate() {
                        this.next = null;
                        while (this.parent.hasNext()) {
                            Object next = this.parent.next();
                            if (!filter.test(next)) continue;
                            this.next = transformer.apply(next);
                            return;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public V next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object next = this.next;
                        this.populate();
                        return next;
                    }
                };
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                for (Object each : input) {
                    if (!filter.test(each)) continue;
                    action.accept(transformer.apply(each));
                }
            }
        };
    }
}

