/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.util.reflections;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.util.reflections.ReflectionUtils;
import io.lumine.xikage.mythicmobs.util.reflections.Reflections;
import io.lumine.xikage.mythicmobs.util.reflections.scanners.Scanner;
import io.lumine.xikage.mythicmobs.util.reflections.scanners.SubTypesScanner;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class VersionCompliantReflections
extends Reflections {
    private static final String SCANNER_CLASS_NAME = SubTypesScanner.class.getSimpleName();

    public VersionCompliantReflections(String configuration) {
        super(configuration, new Scanner[0]);
    }

    @Override
    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        LinkedHashSet<Class<T>> toReturn = new LinkedHashSet<Class<T>>();
        for (String s2 : this.getAllFromStore(type)) {
            try {
                toReturn.add(Class.forName(s2));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    private <T> Iterable<String> getAllFromStore(Class<T> type) {
        Multimap<String, String> mmap = this.store.get(SCANNER_CLASS_NAME);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Predicate<String> inputsFilter = this.configuration.getInputsFilter();
        for (String key : mmap.keySet()) {
            for (String v : mmap.get(key)) {
                if (!inputsFilter.apply(v)) continue;
                result.add(v);
            }
            if (!inputsFilter.apply(key)) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public void expandSuperTypes() {
        if (this.store.keySet().contains(SCANNER_CLASS_NAME)) {
            Multimap<String, String> mmap = this.store.get(SCANNER_CLASS_NAME);
            HashSet<String> s1 = Sets.newHashSet(mmap.keySet());
            HashSet<String> s2 = Sets.newHashSet(mmap.values());
            s1.removeAll(s2);
            HashMultimap<String, String> expand = HashMultimap.create();
            for (String key : s1) {
                Class<?> type = null;
                try {
                    type = Class.forName(key);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                if (type == null) continue;
                this.expandSupertypes(expand, key, type);
            }
            mmap.putAll(expand);
        }
    }

    private void expandSupertypes(Multimap<String, String> mmap, String key, Class<?> type) {
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
            if (!mmap.put(supertype.getName(), key)) continue;
            if (log != null) {
                log.debug("expanded subtype {} -> {}", (Object)supertype.getName(), (Object)key);
            }
            this.expandSupertypes(mmap, supertype.getName(), supertype);
        }
    }
}

