/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.util.physics;

import io.lumine.xikage.mythicmobs.util.physics.PhysicsBlock;
import io.lumine.xikage.mythicmobs.util.physics.PhysicsCollision;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class CollisionHelper {
    @NotNull
    public static List<PhysicsCollision> getCollisions(@NotNull Vector velocity, @NotNull BoundingBox boundingBox, @NotNull World world) {
        PhysicsBlock blockAtIntersection;
        BoundingBox intersection;
        BoundingBox shiftedBoundingBox;
        BoundingBox expandedBoundingBox;
        ArrayList<PhysicsCollision> physicsCollisions = new ArrayList<PhysicsCollision>();
        if (velocity.getX() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.001, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(boundingBox.getHeight(), 0.0, 0.0);
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.WEST));
            }
        } else if (velocity.getX() < 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.001, 0.0, 0.0, 0.0, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(-boundingBox.getHeight(), 0.0, 0.0);
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.EAST));
            }
        }
        if (velocity.getZ() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.0, 0.0, 0.001);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, 0.0, boundingBox.getHeight());
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.NORTH));
            }
        } else if (velocity.getZ() < 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.001, 0.0, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, 0.0, -boundingBox.getHeight());
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.SOUTH));
            }
        }
        if (velocity.getY() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.0, 0.001, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, boundingBox.getHeight(), 0.0);
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.DOWN));
            }
        } else if (velocity.getY() < 0.0) {
            Log.info("Moving downward");
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.001, 0.0, 0.0, 0.001, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, -boundingBox.getHeight(), 0.0);
            intersection = shiftedBoundingBox.intersection(expandedBoundingBox);
            blockAtIntersection = new PhysicsBlock(intersection.getCenter().toLocation(world).getBlock());
            Log.info("Check {0} collides with {1}", blockAtIntersection, intersection);
            if (blockAtIntersection.collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.UP));
            }
        }
        return physicsCollisions;
    }
}

