/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Timing {
    private static final HashMap<String, TimingResults> timings = new HashMap();
    private final String type;
    private final long start = System.nanoTime();
    private long end;

    public Timing(String type) {
        this.type = type;
    }

    public void end() {
        this.end = System.nanoTime();
        if (!timings.containsKey(this.type)) {
            timings.put(this.type, new TimingResults());
        }
        timings.get(this.type).addTiming(this);
    }

    public long getNanoTime() {
        return this.end - this.start;
    }

    public static HashMap<String, TimingResults> getTimings() {
        return timings;
    }

    public static class TimingResults {
        private final List<Timing> timings = new ArrayList<Timing>();

        public void addTiming(Timing timing) {
            this.timings.add(timing);
        }

        public long getAverage() {
            long average = this.getTotal();
            return average /= (long)this.timings.size();
        }

        public long getTotal() {
            long total = 0L;
            for (Timing timing : this.timings) {
                total += timing.getNanoTime();
            }
            return total;
        }
    }
}

