/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.random;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnGenerator;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawner;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnerAction;
import io.lumine.xikage.mythicmobs.spawning.random.SpawnPointType;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawnerManager
extends PluginComponent {
    private List<File> spawnFiles;
    private IOLoader<MythicMobs> defaultSpawns;
    private List<IOLoader<MythicMobs>> spawnLoaders;
    public List<RandomSpawner> listRandomSpawningAddLand = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningAddSea = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningAddAir = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningR = new ArrayList<RandomSpawner>();
    public List<RandomSpawner> listRandomSpawningD = new ArrayList<RandomSpawner>();
    public Set<RandomSpawnPoint> landSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> airSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> seaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> lavaSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<RandomSpawnPoint> groundSpawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public Set<ActiveMob> randomlySpawnedMobs = Collections.newSetFromMap(new ConcurrentHashMap());
    RandomPointGeneratorLand spawnPointGenerator;

    public RandomSpawnerManager(MythicMobs core) {
        super(core);
    }

    public void loadRandomSpawns() {
        this.defaultSpawns = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleRandomSpawns.yml", "RandomSpawns");
        this.spawnFiles = IOHandler.getAllFiles(this.defaultSpawns.getFile().getParent());
        File packsFolder = new File(this.getPlugin().getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "RandomSpawns")).exists() || !confFolder.isDirectory()) continue;
                this.spawnFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.spawnLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), this.spawnFiles, "RandomSpawns");
        this.listRandomSpawningAddLand.clear();
        this.listRandomSpawningAddSea.clear();
        this.listRandomSpawningAddAir.clear();
        this.listRandomSpawningR.clear();
        this.listRandomSpawningD.clear();
        for (IOLoader iOLoader : this.spawnLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfig mc = new MythicConfig(name, iOLoader.getCustomConfig());
                String file = iOLoader.getFile().getName();
                RandomSpawner rs = new RandomSpawner(file, name, mc);
                if (rs.getAction() == RandomSpawnerAction.ADD) {
                    switch (rs.getPositionType()) {
                        case AIR: {
                            this.listRandomSpawningAddAir.add(rs);
                            break;
                        }
                        case GROUND: {
                            break;
                        }
                        case LAND: {
                            this.listRandomSpawningAddLand.add(rs);
                            break;
                        }
                        case LAVA: {
                            break;
                        }
                        case SEA: {
                            this.listRandomSpawningAddSea.add(rs);
                        }
                    }
                    continue;
                }
                if (rs.getAction() == RandomSpawnerAction.DENY) {
                    this.listRandomSpawningD.add(rs);
                    continue;
                }
                this.listRandomSpawningR.add(rs);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting ADD Random Spawners...", new Object[0]);
        this.listRandomSpawningAddLand = this.sortSpawners(this.listRandomSpawningAddLand);
        this.listRandomSpawningAddSea = this.sortSpawners(this.listRandomSpawningAddSea);
        this.listRandomSpawningAddAir = this.sortSpawners(this.listRandomSpawningAddAir);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting REPLACE Random Spawners...", new Object[0]);
        this.listRandomSpawningR = this.sortSpawners(this.listRandomSpawningR);
        if (ConfigManager.generateRSPoints()) {
            if (this.spawnPointGenerator == null && ConfigManager.getRSPointsPerSecondLand() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Starting up SpawnPointGenerator!", new Object[0]);
                this.spawnPointGenerator = new RandomPointGeneratorLand();
            }
        } else if (this.spawnPointGenerator != null) {
            this.spawnPointGenerator.stop();
            this.spawnPointGenerator = null;
        }
    }

    public int getNumberOfSpawners() {
        return this.listRandomSpawningAddLand.size() + this.listRandomSpawningAddSea.size() + this.listRandomSpawningAddAir.size() + this.listRandomSpawningR.size() + this.listRandomSpawningD.size();
    }

    public AbstractEntity handleSpawnEvent(RandomSpawnPoint rsp) {
        if (rsp.getReason() == CreatureSpawnEvent.SpawnReason.NATURAL && BukkitEntityType.getIsSpawning().booleanValue()) {
            return null;
        }
        if (rsp.getEntity() == null) {
            return null;
        }
        if (this.listRandomSpawningR.size() == 0) {
            return null;
        }
        if (!ConfigManager.generateRSPoints()) {
            this.landSpawnPoints.add(rsp);
        }
        for (RandomSpawner RS : this.listRandomSpawningR) {
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            ActiveMob mob = RS.spawn(rsp);
            return mob != null ? mob.getEntity() : null;
        }
        return null;
    }

    @Override
    public void load(MythicMobs plugin) {
        if (ConfigManager.generateRSPoints() && ConfigManager.getRSPointsPerSecondLand() > 0) {
            this.spawnPointGenerator = new RandomPointGeneratorLand();
        }
    }

    @Override
    public void unload() {
        if (this.spawnPointGenerator != null) {
            this.spawnPointGenerator.stop();
        }
    }

    public void spawnMobs() {
        this.landSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp, this.listRandomSpawningAddLand.iterator()));
        this.landSpawnPoints.clear();
        this.seaSpawnPoints.forEach(rsp -> this.doSpawns((RandomSpawnPoint)rsp, this.listRandomSpawningAddSea.iterator()));
        this.seaSpawnPoints.clear();
    }

    public void doSpawns(RandomSpawnPoint rsp, Iterator<RandomSpawner> it) {
        if (rsp == null) {
            return;
        }
        while (it.hasNext()) {
            RandomSpawner RS = it.next();
            if (!RS.checkSpawn(rsp) || !RS.isValid()) continue;
            RS.spawn(rsp);
            return;
        }
    }

    public int getMobsNearPlayer(AbstractPlayer p) {
        int i = 0;
        int spawnRadius = (int)Math.pow(ConfigManager.getRSPlayerRadius(), 2.0);
        for (AbstractEntity e : MythicMobs.inst().getEntityManager().getLivingEntities(p.getLocation().getWorld())) {
            if (!(e.getLocation().distanceSquared(p.getLocation()) <= (double)spawnRadius)) continue;
            ++i;
        }
        return i;
    }

    public Set<RandomSpawnPoint> getLandSpawnPoints() {
        return this.landSpawnPoints;
    }

    public Set<RandomSpawnPoint> getSeaSpawnPoints() {
        return this.seaSpawnPoints;
    }

    private List<RandomSpawner> sortSpawners(List<RandomSpawner> list) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            for (int q = 1; q < list.size() - i; ++q) {
                RandomSpawner o = list.get(q - 1);
                RandomSpawner n = list.get(q);
                if (o.priority >= n.priority) continue;
                list.set(q - 1, n);
                list.set(q, o);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Random Spawns Sorted to:", new Object[0]);
        for (i = 0; i < list.size(); ++i) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "* " + list.get(i).getPriority() + " = " + list.get((int)i).name, new Object[0]);
        }
        return list;
    }

    public class RandomPointGeneratorLand
    extends RandomSpawnGenerator {
        @Override
        public void generateSpawnPoints() {
            if (MythicMobs.inst().getEntityManager().getPlayers().size() <= 0) {
                return;
            }
            MythicMobs.inst().getTimingsHandler().markRandomGeneratorsNew();
            long startTime = System.currentTimeMillis();
            ArrayList<AbstractPlayer> players = new ArrayList<AbstractPlayer>();
            players.addAll(RandomSpawnerManager.this.getPlugin().getEntityManager().getPlayers());
            Collections.shuffle(players);
            int n = 0;
            int spawnRadius = ConfigManager.getRSPlayerRadius();
            int spawnRadiusY = ConfigManager.getRSPlayerRadiusY();
            int minRadiusSquared = 256;
            Iterator itp = players.iterator();
            try {
                while (itp.hasNext()) {
                    AbstractPlayer player = (AbstractPlayer)itp.next();
                    if (player == null || player.isInCreativeMode()) continue;
                    if (System.currentTimeMillis() - startTime > (long)ConfigManager.getRSMaxGenerationTimeMillis()) break;
                    int bucketLand = ConfigManager.getRSPointsPerSecondLand();
                    int bucketSea = ConfigManager.getRSPointsPerSecondSea();
                    int bucketAir = ConfigManager.getRSPointsPerSecondAir();
                    int totalBucket = bucketLand + bucketSea + bucketAir;
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "Generating RandomSpawnPoints near Player {0}", player.getName());
                    while (totalBucket > 0 && System.currentTimeMillis() - startTime <= (long)ConfigManager.getRSMaxGenerationTimeMillis()) {
                        RandomSpawnPoint point;
                        AbstractLocation returnLocation;
                        Location location = BukkitAdapter.adapt(player.getLocation());
                        Location spawnLocation = new Location(location.getWorld(), 0.0, 0.0, 0.0);
                        int nx = (int)(location.getX() - (double)spawnRadius) + Numbers.randomInt(spawnRadius * 2);
                        int nz = (int)(location.getZ() - (double)spawnRadius) + Numbers.randomInt(spawnRadius * 2);
                        int ny = (int)(location.getY() - (double)spawnRadiusY) + Numbers.randomInt(spawnRadiusY * 2);
                        spawnLocation.setX((double)nx);
                        spawnLocation.setY((double)ny);
                        spawnLocation.setZ((double)nz);
                        if (!player.getWorld().isChunkLoaded(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Skipping player, area chunks not loaded.", new Object[0]);
                            --totalBucket;
                            continue;
                        }
                        int mobsInChunk = 0;
                        try {
                            mobsInChunk = player.getWorld().getEntitiesInChunk(spawnLocation.getBlockX() >> 4, spawnLocation.getBlockZ() >> 4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (mobsInChunk >= ConfigManager.getRSMaxMobsPerChunk()) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Too many entities in chunk, skipping", new Object[0]);
                            --totalBucket;
                            continue;
                        }
                        if (spawnLocation.distanceSquared(location) < 256.0) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Distance too far, skipping", new Object[0]);
                            continue;
                        }
                        if (spawnLocation.getBlock().getType() == Material.WATER) {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Found water. Adding Sea point", new Object[0]);
                            returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny, (double)nz + 0.5);
                            point = new RandomSpawnPoint(returnLocation, SpawnPointType.SEA);
                        } else {
                            boolean goodd;
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "+ Adding Land point", new Object[0]);
                            if (!spawnLocation.getBlock().getType().isSolid()) {
                                goodd = false;
                                for (int j = 0; j < spawnRadiusY * 2; ++j) {
                                    spawnLocation.setY((double)(--ny));
                                    if (spawnLocation.getBlock().getType() == Material.WATER) break;
                                    if (!spawnLocation.getBlock().getType().isSolid()) continue;
                                    goodd = true;
                                    break;
                                }
                                if (!goodd) continue;
                            }
                            goodd = true;
                            for (int k = 1; k < 3; ++k) {
                                spawnLocation.setY(spawnLocation.getY() + 1.0);
                                if (!spawnLocation.getBlock().getType().isSolid()) continue;
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! {0} is NOT pathable, skipping", spawnLocation.getBlock().getType().toString());
                                goodd = false;
                                break;
                            }
                            if (!goodd) {
                                MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Couldn't find land position this time", new Object[0]);
                                continue;
                            }
                            returnLocation = new AbstractLocation(player.getWorld(), (double)nx + 0.5, ny + 1, (double)nz + 0.5);
                            point = new RandomSpawnPoint(returnLocation, SpawnPointType.LAND);
                        }
                        if (point == null) continue;
                        Iterator<RandomSpawner> it = RandomSpawnerManager.this.listRandomSpawningD.iterator();
                        boolean good = true;
                        while (it.hasNext()) {
                            RandomSpawner RS = it.next();
                            if (!RS.checkSpawn(point)) continue;
                            good = false;
                            break;
                        }
                        if (good) {
                            if (point.getPointType() == SpawnPointType.LAND && bucketLand > 0) {
                                RandomSpawnerManager.this.landSpawnPoints.add(point);
                                --bucketLand;
                                ++n;
                            } else if (point.getPointType() == SpawnPointType.SEA && bucketSea > 0) {
                                RandomSpawnerManager.this.seaSpawnPoints.add(point);
                                --bucketSea;
                                ++n;
                            }
                            --totalBucket;
                        } else {
                            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "! Skipped spawn point due to DENY action", new Object[0]);
                        }
                        MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "++ Generated Random Point at {0}", point.getLocation().toString());
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Generated Points: {0}", n);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Land Bucket: {0}", bucketLand);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Sea Bucket: {0}", bucketSea);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "[i] Time taken: {0}", System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MythicMobs.inst().getTimingsHandler().markRandomGeneratorsComplete();
        }

        @Override
        public RandomSpawnPoint findPointNearPlayer(AbstractPlayer player, boolean searchLand) {
            return null;
        }
    }
}

