/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.random;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnPoint;
import io.lumine.xikage.mythicmobs.spawning.random.RandomSpawnerAction;
import io.lumine.xikage.mythicmobs.spawning.random.SpawnPointType;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawner {
    public static Set<RandomSpawnPoint> spawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    public String name;
    public List<MythicMob> mobTypes = new ArrayList<MythicMob>();
    RandomSpawnerAction action;
    public int priority;
    public int level;
    public float chance;
    public HashSet<Biome> biomes = new HashSet();
    public HashSet<AbstractWorld> worlds = new HashSet();
    public HashSet<CreatureSpawnEvent.SpawnReason> spawnReasons = new HashSet();
    public List<SkillCondition> conditions;
    private SpawnPointType positionType = SpawnPointType.LAND;
    private boolean hasConditions = false;
    private boolean useWorldScaling = true;

    public RandomSpawner(String file, String name, MythicConfig mc) {
        int n;
        int n2;
        String[] stringArray;
        this.name = name;
        String strAction = mc.getString("SpawnMethod", "ADD");
        strAction = mc.getString("Action", strAction);
        this.action = RandomSpawnerAction.valueOf(strAction.toUpperCase());
        String strMobName = mc.getString("Mobname", "");
        strMobName = mc.getString("MobName", strMobName);
        strMobName = mc.getString("MobType", strMobName);
        strMobName = mc.getString("Type", strMobName);
        strMobName = mc.getString("Types", strMobName);
        if (!strMobName.equalsIgnoreCase("GROUP")) {
            String[] types;
            for (String s2 : types = strMobName.split(",")) {
                MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(s2);
                if (mm3 == null) continue;
                this.mobTypes.add(mm3);
            }
        }
        this.level = mc.getInteger("Level", 1);
        this.chance = (float)mc.getDouble("Chance", 1.0);
        this.priority = mc.getInteger("Priority", 1);
        this.useWorldScaling = mc.getBoolean("UseWorldScaling", true);
        String strPositionType = "LAND";
        try {
            strPositionType = mc.getString("PositionType", "LAND");
            this.positionType = SpawnPointType.valueOf(strPositionType.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorSpawnConfig(this, mc, "'" + strPositionType + "' is not a valid value for PositionType");
            this.positionType = SpawnPointType.LAND;
        }
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s3 : nTConditions) {
            SkillCondition sc;
            if (s3.contains("\"")) {
                String[] split = s3.split("\"");
                int i = 0;
                String ns = "";
                stringArray = split;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String ss = stringArray[n];
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s3 = ns;
            }
            if ((sc = SkillCondition.getCondition(s3)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList<SkillCondition>();
            }
            this.conditions.add(sc);
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            this.hasConditions = true;
        }
        String world = mc.getString("Worlds");
        String biome = mc.getString("Biomes");
        String reasons = mc.getString("Reason");
        reasons = mc.getString("Reasons", reasons);
        if (world != null) {
            String[] worldName = world.split(",");
            World w = null;
            if (worldName != null) {
                stringArray = worldName;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String wName = stringArray[n];
                    w = Bukkit.getWorld((String)wName);
                    if (w == null) continue;
                    this.worlds.add(BukkitAdapter.adapt(w));
                }
            }
        }
        if (biome != null) {
            String[] biomename;
            for (String bName : biomename = biome.split(",")) {
                Biome b = Biome.valueOf((String)bName.toUpperCase());
                if (b == null) continue;
                this.biomes.add(b);
            }
        }
        if (reasons != null) {
            String[] r;
            for (String rr : r = reasons.split(",")) {
                CreatureSpawnEvent.SpawnReason fr = CreatureSpawnEvent.SpawnReason.valueOf((String)rr);
                if (fr == null) continue;
                this.spawnReasons.add(fr);
            }
        }
    }

    public float getChance() {
        return this.chance;
    }

    public int getLevel(AbstractLocation location) {
        int level = this.getBaseLevel();
        if (this.useWorldScaling) {
            level += WorldScaling.getLevelBonus(location);
        }
        return level;
    }

    public int getBaseLevel() {
        return this.level;
    }

    public int getPriority() {
        return this.priority;
    }

    public RandomSpawnerAction getAction() {
        return this.action;
    }

    public HashSet<Biome> getBiomes() {
        return this.biomes;
    }

    public HashSet<AbstractWorld> getWorlds() {
        return this.worlds;
    }

    public HashSet<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.spawnReasons;
    }

    public boolean isValid() {
        return this.mobTypes.size() > 0;
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }

    public boolean checkSpawn(RandomSpawnPoint rsp) {
        if ((double)this.chance < Numbers.randomDouble()) {
            return false;
        }
        if (this.spawnReasons.size() > 0) {
            if (!this.spawnReasons.contains(rsp.getReason())) {
                return false;
            }
        } else {
            switch (rsp.getReason()) {
                case NATURAL: {
                    break;
                }
                case REINFORCEMENTS: {
                    break;
                }
                case VILLAGE_INVASION: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.worlds != null && this.worlds.size() > 0 && !this.worlds.contains(rsp.getLocation().getWorld())) {
            return false;
        }
        if (this.biomes.size() > 0 && !this.biomes.contains(rsp.getBiome())) {
            return false;
        }
        if (this.hasConditions()) {
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateRandomSpawnPoint(rsp)) continue;
                return false;
            }
        }
        return true;
    }

    public ActiveMob spawn(RandomSpawnPoint rsp) {
        MythicMob mm3 = this.mobTypes.size() > 0 ? this.mobTypes.get(Numbers.randomInt(this.mobTypes.size())) : this.mobTypes.get(0);
        return MythicMobs.inst().getMobManager().spawnMob(mm3.getInternalName(), rsp.getLocation(), SpawnReason.NATURAL, (float)this.getLevel(rsp.getLocation()) * rsp.getLevelMod());
    }

    public SpawnPointType getPositionType() {
        return this.positionType;
    }
}

