/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.Collection;
import java.util.HashSet;

public class ThreatTableRandomTargeter
extends IEntitySelector {
    public ThreatTableRandomTargeter(MythicLineConfig mlc) {
        super(mlc);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        if (!(data.getCaster() instanceof ActiveMob)) {
            return targets;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (am.hasThreatTable()) {
            if (am.getThreatTable().size() == 1) {
                targets.add(am.getThreatTable().getTopThreatHolder());
            } else if (am.getThreatTable().size() > 1) {
                int r = Numbers.randomInt(am.getThreatTable().size());
                targets.add((AbstractEntity)am.getThreatTable().getAllThreatTargets().toArray()[r]);
            }
        } else {
            MythicLogger.errorTargeterConfig(this, this.config, "ThreatTable targeters are only available on mobs with Options.UseThreatTable set to True!.");
        }
        return targets;
    }
}

